/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.CoverageDataContainer;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;
import net.sourceforge.cobertura.util.StringUtil;

public class SourceFileData
extends CoverageDataContainer
implements Comparable,
HasBeenInstrumented {
    private static final long serialVersionUID = 3L;
    private String name;
    private boolean containsInstrumentationInfo = false;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$SourceFileData;

    public SourceFileData(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Source file name must be specified.");
        }
        this.name = name;
    }

    public void addClassData(ClassData classData) {
        if (this.children.containsKey(classData.getBaseName())) {
            throw new IllegalArgumentException("Source file " + this.name + " already contains a class with the name " + classData.getBaseName());
        }
        this.children.put(classData.getBaseName(), classData);
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(class$net$sourceforge$cobertura$coveragedata$SourceFileData == null ? (class$net$sourceforge$cobertura$coveragedata$SourceFileData = SourceFileData.class$("net.sourceforge.cobertura.coveragedata.SourceFileData")) : class$net$sourceforge$cobertura$coveragedata$SourceFileData)) {
            return Integer.MAX_VALUE;
        }
        return this.name.compareTo(((SourceFileData)o).name);
    }

    public boolean contains(String name) {
        return this.children.containsKey(name);
    }

    public boolean containsInstrumentationInfo() {
        return this.containsInstrumentationInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        SourceFileData sourceFileData = (SourceFileData)obj;
        return super.equals(obj) && this.name.equals(sourceFileData.name) && this.containsInstrumentationInfo == sourceFileData.containsInstrumentationInfo;
    }

    public String getBaseName() {
        int lastDot = this.name.lastIndexOf(46);
        String fullNameWithoutExtension = lastDot == -1 ? this.name : this.name.substring(0, lastDot);
        int lastSlash = fullNameWithoutExtension.lastIndexOf(47);
        if (lastSlash == -1) {
            return fullNameWithoutExtension;
        }
        return fullNameWithoutExtension.substring(lastSlash + 1);
    }

    public SortedSet getClasses() {
        return new TreeSet(this.children.values());
    }

    public long getHitCount(int lineNumber) {
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            ClassData classData = (ClassData)iter.next();
            if (!classData.isValidSourceLineNumber(lineNumber)) continue;
            return classData.getHitCount(lineNumber);
        }
        return 0L;
    }

    public String getName() {
        return this.name;
    }

    public String getNormalizedName() {
        int lastDot = this.name.lastIndexOf(46);
        String fullNameWithoutExtension = lastDot == -1 ? this.name : this.name.substring(0, lastDot);
        return StringUtil.replaceAll(fullNameWithoutExtension, "/", ".");
    }

    public String getPackageName() {
        int lastSlash = this.name.lastIndexOf(47);
        if (lastSlash == -1) {
            return this.name;
        }
        return StringUtil.replaceAll(this.name.substring(0, lastSlash), "/", ".");
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isValidSourceLineNumber(int lineNumber) {
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            ClassData classData = (ClassData)iter.next();
            if (!classData.isValidSourceLineNumber(lineNumber)) continue;
            return true;
        }
        return false;
    }

    public void merge(CoverageData coverageData) {
        super.merge(coverageData);
        SourceFileData sourceFileData = (SourceFileData)coverageData;
        this.containsInstrumentationInfo |= sourceFileData.containsInstrumentationInfo;
    }

    public void setContainsInstrumentationInfo() {
        this.containsInstrumentationInfo = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

