/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.instrument.ClassInstrumenter;
import net.sourceforge.cobertura.instrument.CustomAttribute;
import net.sourceforge.cobertura.util.CommandLineBuilder;
import net.sourceforge.cobertura.util.Header;
import net.sourceforge.cobertura.util.IOUtil;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Perl5Compiler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class Main {
    private static final Logger logger = Logger.getLogger((Class)(class$net$sourceforge$cobertura$instrument$Main == null ? (class$net$sourceforge$cobertura$instrument$Main = Main.class$("net.sourceforge.cobertura.instrument.Main")) : class$net$sourceforge$cobertura$instrument$Main));
    private File destinationDirectory = null;
    private Collection ignoreRegexes = new Vector();
    private ProjectData projectData = null;
    static /* synthetic */ Class class$net$sourceforge$cobertura$instrument$Main;

    private static boolean isClass(File file) {
        return file.getName().endsWith(".class");
    }

    private static boolean isClass(ZipEntry entry) {
        return entry.getName().endsWith(".class");
    }

    private static boolean isArchive(File file) {
        String name = file.getName();
        return name.endsWith(".jar") || name.endsWith(".zip") || name.endsWith(".war") || name.endsWith(".ear") || name.endsWith(".sar");
    }

    /*
     * WARNING - void declaration
     */
    private void addInstrumentationToArchive(ZipInputStream archive, ZipOutputStream output) throws Exception {
        ZipEntry entry;
        while ((entry = archive.getNextEntry()) != null) {
            void var3_3;
            try {
                ZipEntry outputEntry = new ZipEntry(var3_3.getName());
                output.putNextEntry(outputEntry);
                byte[] entryBytes = IOUtil.createByteArrayFromInputStream(archive);
                if (Main.isClass((ZipEntry)var3_3)) {
                    ClassReader cr = new ClassReader(entryBytes);
                    ClassWriter cw = new ClassWriter(true);
                    ClassInstrumenter cv = new ClassInstrumenter(this.projectData, (ClassVisitor)cw, this.ignoreRegexes);
                    cr.accept((ClassVisitor)cv, CustomAttribute.getExtraAttributes(), false);
                    if (cv.isInstrumented()) {
                        logger.debug((Object)("Putting instrumeted entry: " + var3_3.getName()));
                        entryBytes = cw.toByteArray();
                    }
                }
                output.write(entryBytes);
                output.closeEntry();
                archive.closeEntry();
            }
            catch (Exception e) {
                logger.warn((Object)("Problems with archive entry: " + var3_3));
                throw e;
            }
            ((FilterOutputStream)output).flush();
        }
    }

    private void addInstrumentationToArchive(File archive) {
        IOException e32222;
        ZipOutputStream output;
        File outputFile;
        block40: {
            logger.debug((Object)("Instrumenting archive " + archive.getAbsolutePath()));
            outputFile = null;
            ZipInputStream input = null;
            output = null;
            try {
                try {
                    input = new ZipInputStream(new FileInputStream(archive));
                }
                catch (FileNotFoundException e2) {
                    IOException e32222;
                    logger.warn((Object)("Cannot open archive file: " + archive.getAbsolutePath()), (Throwable)e2);
                    Object var7_9 = null;
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e32222) {
                            // empty catch block
                        }
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException e32222) {
                            // empty catch block
                        }
                    }
                    return;
                }
                try {
                    if (this.destinationDirectory != null) {
                        outputFile = new File(this.destinationDirectory, archive.getName());
                    } else {
                        outputFile = File.createTempFile("CoberturaInstrumentedArchive", "jar");
                        outputFile.deleteOnExit();
                    }
                    output = new ZipOutputStream(new FileOutputStream(outputFile));
                }
                catch (IOException e4) {
                    IOException e32222;
                    logger.warn((Object)("Cannot open file for instrumented archive: " + archive.getAbsolutePath()), (Throwable)e4);
                    Object var7_10 = null;
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e32222) {
                            // empty catch block
                        }
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException e32222) {
                            // empty catch block
                        }
                    }
                    return;
                }
                try {
                    this.addInstrumentationToArchive(input, output);
                }
                catch (Exception e5) {
                    IOException e32222;
                    logger.warn((Object)("Cannot instrument archive: " + archive.getAbsolutePath()), (Throwable)e5);
                    Object var7_11 = null;
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e32222) {
                            // empty catch block
                        }
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException e32222) {
                            // empty catch block
                        }
                    }
                    return;
                }
                Object var7_12 = null;
                if (input == null) break block40;
            }
            catch (Throwable throwable) {
                IOException e32222;
                Object var7_13 = null;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e32222) {
                        // empty catch block
                    }
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e32222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException e32222) {
                // empty catch block
            }
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e32222) {}
        }
        if (this.destinationDirectory == null) {
            try {
                IOUtil.moveFile(outputFile, archive);
            }
            catch (IOException e6) {
                logger.warn((Object)("Cannot instrument archive: " + archive.getAbsolutePath()), (Throwable)e6);
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addInstrumentationToSingleClass(File file) {
        block26: {
            block23: {
                Main.logger.debug((Object)("Instrumenting class " + file.getAbsolutePath()));
                inputStream = null;
                try {
                    inputStream = new FileInputStream(file);
                    cr = new ClassReader((InputStream)inputStream);
                    cw = new ClassWriter(true);
                    cv = new ClassInstrumenter(this.projectData, (ClassVisitor)cw, this.ignoreRegexes);
                    cr.accept((ClassVisitor)cv, CustomAttribute.getExtraAttributes(), false);
                    var7_7 = null;
                    ** if (inputStream == null) goto lbl-1000
                }
                catch (Throwable var6_13) {
                    var7_9 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw var6_13;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block23;
                    catch (Throwable t) {
                        Main.logger.warn((Object)("Unable to instrument file " + file.getAbsolutePath()), t);
                        var7_8 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                }
            }
            outputStream = null;
            try {
                block25: {
                    if (!cv.isInstrumented()) break block25;
                    outputFile = this.destinationDirectory == null ? file : new File(this.destinationDirectory, cv.getClassName().replace('.', File.separatorChar) + ".class");
                    parentFile = outputFile.getParentFile();
                    if (parentFile != null) {
                        parentFile.mkdirs();
                    }
                    instrumentedClass = cw.toByteArray();
                    outputStream = new FileOutputStream(outputFile);
                    outputStream.write(instrumentedClass);
                }
                var10_16 = null;
                ** if (outputStream == null) goto lbl-1000
            }
            catch (Throwable var9_22) {
                var10_18 = null;
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var9_22;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block26;
                catch (Throwable t) {
                    Main.logger.warn((Object)("Unable to instrument file " + file.getAbsolutePath()), t);
                    var10_17 = null;
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
        }
    }

    private void addInstrumentation(File file) {
        if (Main.isClass(file)) {
            this.addInstrumentationToSingleClass(file);
        } else if (file.isDirectory()) {
            File[] contents = file.listFiles();
            int i = 0;
            while (i < contents.length) {
                this.addInstrumentation(contents[i]);
                ++i;
            }
        }
    }

    private void addInstrumentation(String baseDir, String filename) {
        logger.debug((Object)("filename: " + filename));
        File file = new File(baseDir, filename);
        if (Main.isArchive(file)) {
            this.addInstrumentationToArchive(file);
        } else {
            this.addInstrumentation(file);
        }
    }

    private void parseArguments(String[] args) {
        File dataFile = CoverageDataFileHandler.getDefaultDataFile();
        ArrayList<String> filePaths = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--basedir")) {
                filePaths.add(args[i]);
                filePaths.add(args[++i]);
            } else if (args[i].equals("--datafile")) {
                dataFile = new File(args[++i]);
            } else if (args[i].equals("--destination")) {
                this.destinationDirectory = new File(args[++i]);
            } else if (args[i].equals("--ignore")) {
                String regex = args[++i];
                try {
                    Perl5Compiler pc = new Perl5Compiler();
                    this.ignoreRegexes.add(pc.compile(regex));
                }
                catch (MalformedPatternException e) {
                    logger.warn((Object)("The regular expression " + regex + " is invalid: " + e.getLocalizedMessage()));
                }
            } else {
                filePaths.add(args[i]);
            }
            ++i;
        }
        if (dataFile.isFile()) {
            this.projectData = CoverageDataFileHandler.loadCoverageData(dataFile);
        }
        if (this.projectData == null) {
            this.projectData = new ProjectData();
        }
        System.out.println("Instrumenting " + filePaths.size() + " " + (filePaths.size() == 1 ? "class" : "classes") + (this.destinationDirectory != null ? " to " + this.destinationDirectory.getAbsoluteFile() : ""));
        String baseDir = null;
        Iterator iter = filePaths.iterator();
        while (iter.hasNext()) {
            String act = (String)iter.next();
            if (act.equals("--basedir")) {
                baseDir = (String)iter.next();
                continue;
            }
            this.addInstrumentation(baseDir, act);
        }
        CoverageDataFileHandler.saveCoverageData(this.projectData, dataFile);
    }

    public static void main(String[] args) {
        Header.print(System.out);
        long startTime = System.currentTimeMillis();
        Main main = new Main();
        try {
            args = CommandLineBuilder.preprocessCommandLineArguments(args);
        }
        catch (Exception ex) {
            System.err.println("Error: Cannot process arguments: " + ex.getMessage());
            System.exit(1);
        }
        main.parseArguments(args);
        long stopTime = System.currentTimeMillis();
        System.out.println("Instrument time: " + (stopTime - startTime) + "ms");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

