/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javancss.Javancss;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.PackageData;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.coveragedata.SourceFileData;
import net.sourceforge.cobertura.util.FileFinder;
import org.apache.log4j.Logger;

public class ComplexityCalculator {
    private static final Logger logger = Logger.getLogger((Class)(class$net$sourceforge$cobertura$reporting$ComplexityCalculator == null ? (class$net$sourceforge$cobertura$reporting$ComplexityCalculator = ComplexityCalculator.class$("net.sourceforge.cobertura.reporting.ComplexityCalculator")) : class$net$sourceforge$cobertura$reporting$ComplexityCalculator));
    public static final Complexity ZERO_COMPLEXITY = new Complexity(0.0, 0);
    private final FileFinder finder;
    private Map sourceFileCNNCache = new HashMap();
    private Map packageCNNCache = new HashMap();
    static /* synthetic */ Class class$net$sourceforge$cobertura$reporting$ComplexityCalculator;

    public ComplexityCalculator(FileFinder finder) {
        if (finder == null) {
            throw new NullPointerException();
        }
        this.finder = finder;
    }

    private Complexity getAccumlatedCCNForSingleFile(File file) {
        Javancss javancss = new Javancss(file.getAbsolutePath());
        Vector functionMetrics = javancss.getFunctionMetrics();
        if (functionMetrics.size() <= 0) {
            return ZERO_COMPLEXITY;
        }
        int ccnAccumulator = 0;
        Iterator iter = functionMetrics.iterator();
        while (iter.hasNext()) {
            Vector functionMetric = (Vector)iter.next();
            ccnAccumulator += ((Integer)functionMetric.elementAt(2)).intValue();
        }
        return new Complexity(ccnAccumulator, functionMetrics.size());
    }

    public double getCCNForProject(ProjectData projectData) {
        Complexity act = new Complexity();
        Iterator it = projectData.getPackages().iterator();
        while (it.hasNext()) {
            PackageData packageData = (PackageData)it.next();
            act.add(this.getCCNForPackageInternal(packageData));
        }
        return act.averageCCN();
    }

    public double getCCNForPackage(PackageData packageData) {
        return this.getCCNForPackageInternal(packageData).averageCCN();
    }

    private Complexity getCCNForPackageInternal(PackageData packageData) {
        Complexity cachedCCN = (Complexity)this.packageCNNCache.get(packageData.getName());
        if (cachedCCN != null) {
            return cachedCCN;
        }
        Complexity act = new Complexity();
        Iterator it = packageData.getSourceFiles().iterator();
        while (it.hasNext()) {
            SourceFileData sourceData = (SourceFileData)it.next();
            act.add(this.getCCNForSourceFileNameInternal(sourceData.getName()));
        }
        this.packageCNNCache.put(packageData.getName(), act);
        return act;
    }

    public double getCCNForSourceFile(SourceFileData sourceFile) {
        return this.getCCNForSourceFileNameInternal(sourceFile.getName()).averageCCN();
    }

    private Complexity getCCNForSourceFileNameInternal(String sourceFileName) {
        Complexity cachedCCN = (Complexity)this.sourceFileCNNCache.get(sourceFileName);
        if (cachedCCN != null) {
            return cachedCCN;
        }
        Complexity result = ZERO_COMPLEXITY;
        try {
            result = this.getAccumlatedCCNForSingleFile(this.finder.getFileForSource(sourceFileName));
        }
        catch (IOException ex) {
            logger.info((Object)("Cannot find source file during CCN computation, source=[" + sourceFileName + "]"));
        }
        this.sourceFileCNNCache.put(sourceFileName, result);
        return result;
    }

    public double getCCNForClass(ClassData classData) {
        return this.getCCNForSourceFileNameInternal(classData.getSourceFileName()).averageCCN();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Complexity {
        private double accumlatedCCN;
        private int methodsNum;

        public Complexity(double accumlatedCCN, int methodsNum) {
            this.accumlatedCCN = accumlatedCCN;
            this.methodsNum = methodsNum;
        }

        public Complexity() {
            this(0.0, 0);
        }

        public double averageCCN() {
            if (this.methodsNum == 0) {
                return 0.0;
            }
            return this.accumlatedCCN / (double)this.methodsNum;
        }

        public void add(Complexity second) {
            this.accumlatedCCN += second.accumlatedCCN;
            this.methodsNum += second.methodsNum;
        }
    }
}

