/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting.html;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import net.sourceforge.cobertura.coveragedata.PackageData;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.coveragedata.SourceFileData;
import net.sourceforge.cobertura.reporting.ComplexityCalculator;
import net.sourceforge.cobertura.reporting.html.JavaToHtml;
import net.sourceforge.cobertura.reporting.html.SourceFileDataBaseNameComparator;
import net.sourceforge.cobertura.reporting.html.files.CopyFiles;
import net.sourceforge.cobertura.util.FileFinder;
import net.sourceforge.cobertura.util.Header;
import org.apache.log4j.Logger;

public class HTMLReport {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$net$sourceforge$cobertura$reporting$html$HTMLReport == null ? (class$net$sourceforge$cobertura$reporting$html$HTMLReport = HTMLReport.class$("net.sourceforge.cobertura.reporting.html.HTMLReport")) : class$net$sourceforge$cobertura$reporting$html$HTMLReport));
    private File destinationDir;
    private FileFinder finder;
    private ComplexityCalculator complexity;
    private ProjectData projectData;
    static /* synthetic */ Class class$net$sourceforge$cobertura$reporting$html$HTMLReport;

    public HTMLReport(ProjectData projectData, File outputDir, FileFinder finder, ComplexityCalculator complexity) throws Exception {
        this.destinationDir = outputDir;
        this.finder = finder;
        this.complexity = complexity;
        this.projectData = projectData;
        CopyFiles.copy(outputDir);
        this.generatePackageList();
        this.generateSourceFileLists();
        this.generateOverviews();
        this.generateSourceFiles();
    }

    private String generatePackageName(PackageData packageData) {
        if (packageData.getName().equals("")) {
            return "(default)";
        }
        return packageData.getName();
    }

    private void generatePackageList() throws IOException {
        File file = new File(this.destinationDir, "frame-packages.html");
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(file));
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
            out.println("           \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">");
            out.println("<head>");
            out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
            out.println("<title>Coverage Report</title>");
            out.println("<link title=\"Style\" type=\"text/css\" rel=\"stylesheet\" href=\"css/main.css\" />");
            out.println("</head>");
            out.println("<body>");
            out.println("<h5>Packages</h5>");
            out.println("<table width=\"100%\">");
            out.println("<tr>");
            out.println("<td nowrap=\"nowrap\"><a href=\"frame-summary.html\" onclick='parent.sourceFileList.location.href=\"frame-sourcefiles.html\"' target=\"summary\">All</a></td>");
            out.println("</tr>");
            Iterator iter = this.projectData.getPackages().iterator();
            while (iter.hasNext()) {
                PackageData packageData = (PackageData)iter.next();
                String url1 = "frame-summary-" + packageData.getName() + ".html";
                String url2 = "frame-sourcefiles-" + packageData.getName() + ".html";
                out.println("<tr>");
                out.println("<td nowrap=\"nowrap\"><a href=\"" + url1 + "\" onclick='parent.sourceFileList.location.href=\"" + url2 + "\"' target=\"summary\">" + this.generatePackageName(packageData) + "</a></td>");
                out.println("</tr>");
            }
            out.println("</table>");
            out.println("</body>");
            out.println("</html>");
            Object var8_7 = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
    }

    private void generateSourceFileLists() throws IOException {
        this.generateSourceFileList(null);
        Iterator iter = this.projectData.getPackages().iterator();
        while (iter.hasNext()) {
            PackageData packageData = (PackageData)iter.next();
            this.generateSourceFileList(packageData);
        }
    }

    private void generateSourceFileList(PackageData packageData) throws IOException {
        Collection sourceFiles;
        String filename;
        if (packageData == null) {
            filename = "frame-sourcefiles.html";
            sourceFiles = this.projectData.getSourceFiles();
        } else {
            filename = "frame-sourcefiles-" + packageData.getName() + ".html";
            sourceFiles = packageData.getSourceFiles();
        }
        Vector sortedSourceFiles = new Vector();
        sortedSourceFiles.addAll(sourceFiles);
        Collections.sort(sortedSourceFiles, new SourceFileDataBaseNameComparator());
        File file = new File(this.destinationDir, filename);
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(file));
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
            out.println("           \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            out.println("<html>");
            out.println("<head>");
            out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>");
            out.println("<title>Coverage Report Classes</title>");
            out.println("<link title=\"Style\" type=\"text/css\" rel=\"stylesheet\" href=\"css/main.css\"/>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h5>");
            out.println(packageData == null ? "All Packages" : this.generatePackageName(packageData));
            out.println("</h5>");
            out.println("<div class=\"separator\">&nbsp;</div>");
            out.println("<h5>Classes</h5>");
            if (!sortedSourceFiles.isEmpty()) {
                out.println("<table width=\"100%\">");
                out.println("<tbody>");
                Iterator iter = ((AbstractList)sortedSourceFiles).iterator();
                while (iter.hasNext()) {
                    SourceFileData sourceFileData = (SourceFileData)iter.next();
                    out.println("<tr>");
                    String percentCovered = sourceFileData.getNumberOfValidLines() > 0 ? HTMLReport.getPercentValue(sourceFileData.getLineCoverageRate()) : "N/A";
                    out.println("<td nowrap=\"nowrap\"><a target=\"summary\" href=\"" + sourceFileData.getNormalizedName() + ".html\">" + sourceFileData.getBaseName() + "</a> <i>(" + percentCovered + ")</i></td>");
                    out.println("</tr>");
                }
                out.println("</tbody>");
                out.println("</table>");
            }
            out.println("</body>");
            out.println("</html>");
            Object var11_10 = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
    }

    private void generateOverviews() throws IOException {
        this.generateOverview(null);
        Iterator iter = this.projectData.getPackages().iterator();
        while (iter.hasNext()) {
            PackageData packageData = (PackageData)iter.next();
            this.generateOverview(packageData);
        }
    }

    private void generateOverview(PackageData packageData) throws IOException {
        String filename = packageData == null ? "frame-summary.html" : "frame-summary-" + packageData.getName() + ".html";
        File file = new File(this.destinationDir, filename);
        PrintStream out = null;
        try {
            PackageData defaultPackage;
            SortedSet packages;
            out = new PrintStream(new FileOutputStream(file));
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
            out.println("           \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            out.println("<html>");
            out.println("<head>");
            out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>");
            out.println("<title>Coverage Report</title>");
            out.println("<link title=\"Style\" type=\"text/css\" rel=\"stylesheet\" href=\"css/main.css\"/>");
            out.println("<link title=\"Style\" type=\"text/css\" rel=\"stylesheet\" href=\"css/sortabletable.css\"/>");
            out.println("<script type=\"text/javascript\" src=\"js/popup.js\"></script>");
            out.println("<script type=\"text/javascript\" src=\"js/sortabletable.js\"></script>");
            out.println("<script type=\"text/javascript\" src=\"js/customsorttypes.js\"></script>");
            out.println("</head>");
            out.println("<body>");
            out.print("<h5>Coverage Report - ");
            out.print(packageData == null ? "All Packages" : this.generatePackageName(packageData));
            out.println("</h5>");
            out.println("<div class=\"separator\">&nbsp;</div>");
            out.println("<table class=\"report\" id=\"packageResults\">");
            out.println(HTMLReport.generateTableHeader("Package", true));
            out.println("<tbody>");
            if (packageData == null) {
                out.println(this.generateTableRowForTotal());
                packages = this.projectData.getPackages();
            } else {
                packages = this.projectData.getSubPackages(packageData.getName());
            }
            Iterator iter = packages.iterator();
            while (iter.hasNext()) {
                PackageData subPackageData = (PackageData)iter.next();
                out.println(this.generateTableRowForPackage(subPackageData));
            }
            out.println("</tbody>");
            out.println("</table>");
            out.println("<script type=\"text/javascript\">");
            out.println("var packageTable = new SortableTable(document.getElementById(\"packageResults\"),");
            out.println("    [\"String\", \"Number\", \"Percentage\", \"Percentage\", \"FormattedNumber\"]);");
            out.println("packageTable.sort(0);");
            out.println("</script>");
            SortedSet sourceFiles = packageData == null ? ((defaultPackage = (PackageData)this.projectData.getChild("")) != null ? defaultPackage.getSourceFiles() : new TreeSet()) : packageData.getSourceFiles();
            if (sourceFiles.size() > 0) {
                out.println("<div class=\"separator\">&nbsp;</div>");
                out.println("<table class=\"report\" id=\"classResults\">");
                out.println(HTMLReport.generateTableHeader("Classes in this Package", false));
                out.println("<tbody>");
                iter = sourceFiles.iterator();
                while (iter.hasNext()) {
                    SourceFileData sourceFileData = (SourceFileData)iter.next();
                    out.println(this.generateTableRowForSourceFile(sourceFileData));
                }
                out.println("</tbody>");
                out.println("</table>");
                out.println("<script type=\"text/javascript\">");
                out.println("var classTable = new SortableTable(document.getElementById(\"classResults\"),");
                out.println("    [\"String\", \"Percentage\", \"Percentage\", \"FormattedNumber\"]);");
                out.println("classTable.sort(0);");
                out.println("</script>");
            }
            String date = DateFormat.getInstance().format(new Date());
            out.println("<div class=\"footer\">");
            out.println("Report generated by <a href=\"http://cobertura.sourceforge.net/\" target=\"_top\">Cobertura</a> " + Header.version() + " on " + date + ".");
            out.println("</div>");
            out.println("</body>");
            out.println("</html>");
            Object var10_9 = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
    }

    private void generateSourceFiles() {
        Iterator iter = this.projectData.getSourceFiles().iterator();
        while (iter.hasNext()) {
            SourceFileData sourceFileData = (SourceFileData)iter.next();
            try {
                this.generateSourceFile(sourceFileData);
            }
            catch (IOException e) {
                LOGGER.info((Object)("Could not generate HTML file for source file " + sourceFileData.getName() + ": " + e.getLocalizedMessage()));
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateSourceFile(SourceFileData sourceFileData) throws IOException {
        if (!sourceFileData.containsInstrumentationInfo()) {
            LOGGER.info((Object)("Data file does not contain instrumentation information for the file " + sourceFileData.getName() + ".  Ensure this class was instrumented, and this " + "data file contains the instrumentation information."));
        }
        String filename = sourceFileData.getNormalizedName() + ".html";
        File file = new File(this.destinationDir, filename);
        PrintStream out = null;
        try {
            block12: {
                out = new PrintStream(new FileOutputStream(file));
                out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
                out.println("           \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
                out.println("<html>");
                out.println("<head>");
                out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>");
                out.println("<title>Coverage Report</title>");
                out.println("<link title=\"Style\" type=\"text/css\" rel=\"stylesheet\" href=\"css/main.css\"/>");
                out.println("<script type=\"text/javascript\" src=\"js/popup.js\"></script>");
                out.println("</head>");
                out.println("<body>");
                out.print("<h5>Coverage Report - ");
                String classPackageName = sourceFileData.getPackageName();
                if (classPackageName != null && classPackageName.length() > 0) {
                    out.print(sourceFileData.getPackageName() + ".");
                }
                out.print(sourceFileData.getBaseName());
                out.println("</h5>");
                out.println("<div class=\"separator\">&nbsp;</div>");
                out.println("<table class=\"report\">");
                out.println(HTMLReport.generateTableHeader("Classes in this File", false));
                out.println(this.generateTableRowForSourceFile(sourceFileData));
                out.println("</table>");
                out.println("<div class=\"separator\">&nbsp;</div>");
                out.println("<table cellspacing=\"0\" cellpadding=\"0\" class=\"src\">");
                BufferedReader br = null;
                try {
                    File sourceFile = this.finder.getFileForSource(sourceFileData.getName());
                    br = new BufferedReader(new FileReader(sourceFile));
                    JavaToHtml javaToHtml = new JavaToHtml();
                    int lineNumber = 1;
                    while (true) {
                        void var8_10;
                        String lineStr;
                        if ((lineStr = br.readLine()) == null) {
                            Object var14_12 = null;
                            if (br == null) break block12;
                            break;
                        }
                        out.println("<tr>");
                        if (sourceFileData.isValidSourceLineNumber(lineNumber)) {
                            long numberOfHits = sourceFileData.getHitCount(lineNumber);
                            out.println("  <td class=\"numLineCover\">&nbsp;" + lineNumber + "</td>");
                            if (numberOfHits > 0L) {
                                out.println("  <td class=\"nbHitsCovered\">&nbsp;" + numberOfHits + "</td>");
                                out.println("  <td class=\"src\"><pre class=\"src\">&nbsp;" + javaToHtml.process((String)var8_10) + "</pre></td>");
                            } else {
                                out.println("  <td class=\"nbHitsUncovered\">&nbsp;" + numberOfHits + "</td>");
                                out.println("  <td class=\"src\"><pre class=\"src\"><span class=\"srcUncovered\">&nbsp;" + javaToHtml.process((String)var8_10) + "</span></pre></td>");
                            }
                        } else {
                            out.println("  <td class=\"numLine\">&nbsp;" + lineNumber + "</td>");
                            out.println("  <td class=\"nbHits\">&nbsp;</td>");
                            out.println("  <td class=\"src\"><pre class=\"src\">&nbsp;" + javaToHtml.process((String)var8_10) + "</pre></td>");
                        }
                        out.println("</tr>");
                        ++lineNumber;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_13 = null;
                    if (br == null) throw throwable;
                    br.close();
                    throw throwable;
                }
                br.close();
            }
            out.println("</table>");
            out.println("<div class=\"footer\">");
            out.println("Reports generated by <a href=\"http://cobertura.sourceforge.net/\" target=\"_top\">Cobertura</a>.");
            out.println("</div>");
            out.println("</body>");
            out.println("</html>");
            Object var16_15 = null;
            if (out == null) return;
            out.close();
            return;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
    }

    private static String generateTableHeader(String title, boolean showColumnForNumberOfClasses) {
        StringBuffer ret = new StringBuffer();
        ret.append("<thead>");
        ret.append("<tr>");
        ret.append("  <td class=\"heading\">" + title + "</td>");
        if (showColumnForNumberOfClasses) {
            ret.append("  <td class=\"heading\"># Classes</td>");
        }
        ret.append("  <td class=\"heading\" width=\"20%\">" + HTMLReport.generateHelpURL("Line Coverage", "The percent of lines executed by this test run.") + "</td>");
        ret.append("  <td class=\"heading\" width=\"20%\">" + HTMLReport.generateHelpURL("Branch Coverage", "The percent of branches executed by this test run.") + "</td>");
        ret.append("  <td class=\"heading\" width=\"10%\">" + HTMLReport.generateHelpURL("Complexity", "Average McCabe's cyclomatic code complexity for all methods.  This is basically a count of the number of different code paths in a method (incremented by 1 for each if statement, while loop, etc.)") + "</td>");
        ret.append("</tr>");
        ret.append("</thead>");
        return ret.toString();
    }

    private static String generateHelpURL(String text, String description) {
        StringBuffer ret = new StringBuffer();
        boolean popupTooltips = false;
        if (popupTooltips) {
            ret.append("<a class=\"hastooltip\" href=\"help.html\" onclick=\"popupwindow('help.html'); return false;\">");
            ret.append(text);
            ret.append("<span>" + description + "</span>");
            ret.append("</a>");
        } else {
            ret.append("<a class=\"dfn\" href=\"help.html\" onclick=\"popupwindow('help.html'); return false;\">");
            ret.append(text);
            ret.append("</a>");
        }
        return ret.toString();
    }

    private static String generateNAPercent() {
        StringBuffer sb = new StringBuffer();
        sb.append("<table cellpadding=\"0\" cellspacing=\"0\" align=\"right\">");
        sb.append("<tr>");
        sb.append("<td>" + HTMLReport.generateHelpURL("N/A", "Line coverage and branch coverage will appear as \"Not Applicable\" when Cobertura can not find line number information in the .class file.  This happens for stub and skeleton classes, interfaces, or when the class was not compiled with \"debug=true.\"") + "&nbsp;</td>");
        sb.append("<td>");
        sb.append("<table class=\"percentGraph\" cellpadding=\"0\" cellspacing=\"0\" width=\"100\">");
        sb.append("<tr><td class=\"NA\" width=\"100\"></td></tr>");
        sb.append("</table>");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        return sb.toString();
    }

    private static String generateTableColumnsFromData(double lineCoverage, double branchCoverage, double ccn) {
        String lineCoverageCell = lineCoverage == -1.0 ? HTMLReport.generateNAPercent() : HTMLReport.generatePercentResult(lineCoverage);
        String branchCoverageCell = branchCoverage == -1.0 ? HTMLReport.generateNAPercent() : HTMLReport.generatePercentResult(branchCoverage);
        return "<td class=\"value\">" + lineCoverageCell + "</td>" + "<td class=\"value\">" + branchCoverageCell + "</td>" + "<td class=\"value\"><span class=\"hidden\">" + ccn + ";</span>" + HTMLReport.getDoubleValue(ccn) + "</td>";
    }

    private String generateTableRowForTotal() {
        StringBuffer ret = new StringBuffer();
        double lineCoverage = -1.0;
        double branchCoverage = -1.0;
        double ccn = this.complexity.getCCNForProject(this.projectData);
        if (this.projectData.getNumberOfValidLines() > 0) {
            lineCoverage = this.projectData.getLineCoverageRate();
        }
        if (this.projectData.getNumberOfValidBranches() > 0) {
            branchCoverage = this.projectData.getBranchCoverageRate();
        }
        ret.append("  <tr>");
        ret.append("<td class=\"text\"><b>All Packages</b></td>");
        ret.append("<td class=\"value\">" + this.projectData.getNumberOfSourceFiles() + "</td>");
        ret.append(HTMLReport.generateTableColumnsFromData(lineCoverage, branchCoverage, ccn));
        ret.append("</tr>");
        return ret.toString();
    }

    private String generateTableRowForPackage(PackageData packageData) {
        StringBuffer ret = new StringBuffer();
        String url1 = "frame-summary-" + packageData.getName() + ".html";
        String url2 = "frame-sourcefiles-" + packageData.getName() + ".html";
        double lineCoverage = -1.0;
        double branchCoverage = -1.0;
        double ccn = this.complexity.getCCNForPackage(packageData);
        if (packageData.getNumberOfValidLines() > 0) {
            lineCoverage = packageData.getLineCoverageRate();
        }
        if (packageData.getNumberOfValidBranches() > 0) {
            branchCoverage = packageData.getBranchCoverageRate();
        }
        ret.append("  <tr>");
        ret.append("<td class=\"text\"><a href=\"" + url1 + "\" onclick='parent.sourceFileList.location.href=\"" + url2 + "\"'>" + this.generatePackageName(packageData) + "</a></td>");
        ret.append("<td class=\"value\">" + packageData.getNumberOfChildren() + "</td>");
        ret.append(HTMLReport.generateTableColumnsFromData(lineCoverage, branchCoverage, ccn));
        ret.append("</tr>");
        return ret.toString();
    }

    private String generateTableRowForSourceFile(SourceFileData sourceFileData) {
        StringBuffer ret = new StringBuffer();
        double lineCoverage = -1.0;
        double branchCoverage = -1.0;
        double ccn = this.complexity.getCCNForSourceFile(sourceFileData);
        if (sourceFileData.getNumberOfValidLines() > 0) {
            lineCoverage = sourceFileData.getLineCoverageRate();
        }
        if (sourceFileData.getNumberOfValidBranches() > 0) {
            branchCoverage = sourceFileData.getBranchCoverageRate();
        }
        ret.append("  <tr>");
        ret.append("<td class=\"text\"><a href=\"" + sourceFileData.getNormalizedName() + ".html\">" + sourceFileData.getBaseName() + "</a></td>");
        ret.append(HTMLReport.generateTableColumnsFromData(lineCoverage, branchCoverage, ccn));
        ret.append("</tr>");
        return ret.toString();
    }

    private static String generatePercentResult(double percentValue) {
        double rest = 1.0 - percentValue;
        StringBuffer sb = new StringBuffer();
        sb.append("<table cellpadding=\"0\" cellspacing=\"0\" align=\"right\">");
        sb.append("<tr>");
        sb.append("<td>" + HTMLReport.getPercentValue(percentValue) + "&nbsp;</td>");
        sb.append("<td>");
        sb.append("<table class=\"percentGraph\" cellpadding=\"0\" cellspacing=\"0\" width=\"100\">");
        sb.append("<tr>");
        sb.append("<td class=\"covered\" width=\"" + (int)(percentValue * 100.0) + "\"></td>");
        sb.append("<td class=\"uncovered\" width=\"" + (int)(rest * 100.0) + "\"></td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        return sb.toString();
    }

    private static String getDoubleValue(double value) {
        DecimalFormat formatter = new DecimalFormat();
        return formatter.format(value);
    }

    private static String getPercentValue(double value) {
        NumberFormat formatter = NumberFormat.getPercentInstance();
        return formatter.format(value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

