/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.apache.commons.logging.impl;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;


/**
 * {@link org.apache.commons.logging.impl.Log4JLogger}TRACEɖΉȂ̂ŁA
 * ΉLoggerłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class Log4J1212Logger extends Log4JLogger {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6947810340410257926L;
	
	/** The fully qualified name of the Log4JLogger class. */
    private static final String FQCN = Log4J1212Logger.class.getName();
    

	/**
	 * 
	 */
	public Log4J1212Logger() {
		super();
	}
	

	/**
	 * @param logger
	 */
	public Log4J1212Logger(Logger logger) {
		super(logger);
	}


	/**
	 * @param name
	 */
	public Log4J1212Logger(String name) {
		super(name);
	}


	/* (non-Javadoc)
	 * @see org.apache.commons.logging.Log#isTraceEnabled()
	 */
	@Override
	public boolean isTraceEnabled() {
		return getLogger().isTraceEnabled();
	}

	/* (non-Javadoc)
	 * @see org.apache.commons.logging.Log#trace(java.lang.Object, java.lang.Throwable)
	 */
	@Override
	public void trace(Object message, Throwable t) {
        getLogger().log(FQCN, Level.TRACE, message, t );
	}

	/* (non-Javadoc)
	 * @see org.apache.commons.logging.Log#trace(java.lang.Object)
	 */
	@Override
	public void trace(Object message) {
        getLogger().log(FQCN, Level.TRACE, message, null );
	}
}
