/*  
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.cmd;

/**
 * {@link #execute()}{@link #undo()}̏ԑJڂǗĂ܂B<br>
 * TuNX͌p̃\bhKĂяoĂB<br>
 * <code>
 * public void execute() {<br>
 *     super.execute();<br>
 *     `ۂ̏`<br>
 * }<br>
 * <br>
 * public void undo() {<br>
 *     super.undo();<br>
 *     `ۂ̏`<br>
 * }
 * </code>
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
abstract public class AbstractCommand implements Command {
	private boolean isExecuted_;

	/**
	 * 
	 */
	public AbstractCommand() {
		super();
		isExecuted_ = false;
	}

	/**
	 * ̃\bhĂяoƂŁAR}hs\ł邱Ƃۏ؂܂B<br>
	 * TuNX͌p̃\bhKĂяoĂB<br>
	 * 
	 * <pre>
	 *  public void execute() {
	 *    super.execute();
	 *      `ۂ̏`
	 *  }
	 * </pre>
	 * 
	 * @throws IllegalStateException
	 *         R}hss\łꍇB
	 */
	public void execute() {
		if (isExecuted_) {
			throw new IllegalStateException(
					"Command " + this.toString() //$NON-NLS-1$ 
					+ " has already executed."); //$NON-NLS-1$
		}
		isExecuted_ = true;
	}

	/**
	 * ̃\bhĂяoƂŁAR}hundo\ł邱Ƃۏ؂܂B
	 * TuNX͌p̃\bhKĂяoĂB<br>
	 * <pre>
	 * public void undo() {
	 *     super.undo();
	 *     `ۂ̏`
	 * }
	 * </pre>
	 * @throws IllegalStateException R}hundos\łꍇB
	 */
	public void undo() {
		if (!isExecuted_) {
			throw new IllegalStateException(
					"Command " + this.toString() //$NON-NLS-1$
					+ " has already undone."); //$NON-NLS-1$
		}
		isExecuted_ = false;
	}

}
