/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.io;

import java.io.File;

import org.apache.commons.io.FilenameUtils;

import org.unitarou.util.ArgumentChecker;

/**
 * {@link java.io.File}pX̂uԂ̃t@CTCYA
 * ŏIXVɂẴXibvVbgێ܂B<br>
 * {@link java.io.File}̃CX^XԂL
 * CX^X쐬ł͂Ȃ\bhĂяoɂȂĂ邽߂łB
 * 
 * t@CύX̊mFȂǂɗp܂B
 * ̃NX̃tB[hImmutablełB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class FileSnapshot {
	/**
	 * XibvVbg̑ΏۂƂȂt@CłB
	 */
	private final File file_;
	
	/**
	 * XibvVbg_ł̍ŏIXVłB
	 */
	private final long lastModified_;
	
	/**
	 * XibvVbg_ł̃t@CTCYłB
	 */
	private final long length_;
	
	
	/**
	 * ̃RXgN^ĂяoꂽiKł̃XibvVbg쐬܂B 
	 */
	public FileSnapshot(File file) {
		super();
		ArgumentChecker.throwIfNull(file);
		file_ = file;
		lastModified_ = file_.lastModified();
		length_ = file_.length();
	}
	
	/**
	 * XibvVbg̑ΏۂƂȂt@CԂ܂B
	 * @return Returns the file.
	 */
	public File file() {
		return file_;
	}

	/**
	 * XibvVbg_ł̍ŏIXVԂ܂B
	 * @return Returns the lastModified.
	 */
	public long lastModified() {
		return lastModified_;
	}

	/**
	 * XibvVbg_ł̃t@CTCYԂ܂B
	 * @return Returns the length.
	 */
	public long length() {
		return length_;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		
		if (obj == null || !(obj.getClass().equals(this.getClass()))) {
			return false;
		}
		FileSnapshot dest = (FileSnapshot)obj;
		return lastModified_ == dest.lastModified_
				&& length_ == dest.length_
				&& FilenameUtils.equalsOnSystem(file_.getAbsolutePath(), dest.file_.getAbsolutePath());
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		String path = file_.getAbsolutePath();
		if (File.separatorChar == '\\') {
			path = path.toUpperCase();
		}
		return (int)(path.hashCode() * 1009 + lastModified_ * 1013  + length_ * 1019);
	}
}
