/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.jface;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

import org.unitarou.lang.Classes;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link org.eclipse.swt.graphics.Color}pɁA
 * o^L[ƃ\[XێNXłB
 * {@link #get()}ŕԂ
 * IuWFNgColorRegistryŊǗ̂dispose͕svłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class ColorResource {
    /**
     * JFaceResourcesǗĂJ[WXg[łB 
     * CX^X͐F̓o^ɂ̃WXg[g܂B
     */
    static private ColorRegistry colorRegistry_s_ = JFaceResources.getColorRegistry();
    
    /**
     * 
     */
    static private int counter_s_ = 0;

    /** ̃CX^XێĂ郊\[X̃L[łB */
    protected final String key_;

    /**
     * clazzkeyŎʂłF`܂B
     * @param clazz L[͂̃NXxŃj[NɂȂ܂B
     * @param key \[Xʂ邽߂̃L[łB
     * @param rgb ۂ̐FłB
     * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public ColorResource(Class clazz, String key, RGB rgb) {
        super();
        ArgumentChecker.throwIfNull(clazz, key, rgb);
        key_ = Classes.uniqueKey(clazz, key);
        colorRegistry_s_.put(key_, rgb);        
    }
    
    
    /**
     * FɖOsvȏꍇɗpRXgN^łB
     * L[̓O[oɃj[NȒlŊU܂B
     */
    public ColorResource(int red, int green, int blue) {
        this(new RGB(red, green, blue));
    }
    
    /**
     * SWT́gCOLOR_hŎn܂idŐFw肷RXgN^łB
     * L[̓O[oɃj[NȒlŊU܂B
     * @param id Fw肷ID(ex. SWT.COLOR_WIDGET_BORDER)
     */
    public ColorResource(int id) {
        this(Display.getDefault().getSystemColor(id).getRGB());
    }

    /**
     * FɖOsvȏꍇɗpRXgN^łB
     * L[̓O[oɃj[NȒlŊU܂B
     * @param rgb
     * @throws org.unitarou.lang.NullArgumentException rgbnull̏ꍇ
     */
    public ColorResource(RGB rgb) {
        super();
        ArgumentChecker.throwIfNull(rgb);
        
        synchronized(ColorResource.class) {
            key_ = String.valueOf(counter_s_);
            ++counter_s_;
        }
        colorRegistry_s_.put(key_, rgb);        
    }
    
    /**
     * ColorԂ܂Bdispose͕svłB 
     */
    public Color get() {
        return colorRegistry_s_.get(key_);
    }

}
