/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.jface;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;


/**
 * {@link org.eclipse.swt.graphics.Cursor}p
 * o^L[ƃ\[XǗNXłB
 * {@link #getCursor()}ŕԂIuWFNg
 * ̃NXǗ̂dispose͕svłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class CursorResource extends ImageResource {
    /** K[ */
	static private final Log log_s_ = LogFactory.getLog(CursorResource.class);

	/**
     * ^[String:key, Cursor]
     */
    static private final Map<String, Cursor> cursorMap_s_;
    static private final DisposeListener disposeListener_s_;
    
    static {
        cursorMap_s_ = new TreeMap<String, Cursor>();    
        disposeListener_s_ = new DisposeListener() {
            public void widgetDisposed(DisposeEvent e) {
                for (Iterator ip = cursorMap_s_.values().iterator(); ip.hasNext(); ) {
                    ((Cursor)ip.next()).dispose();
                }
                cursorMap_s_.clear();
            }
        };
    }

    private Cursor cursor_;
    
    private final Point hotspot_;
    
    /**
     * @param clazz
     * @param key
     * @param filename
     */
    public CursorResource(Class clazz, String filename, Point hotspot) {
        super(clazz, filename);
        cursor_ = null;
        hotspot_ = hotspot;
   }

    public Cursor getCursor() {
        if (cursor_ == null) {
            setup();
        } else if (cursor_.isDisposed()) {
        	log_s_.warn("Cursor (" +  key_ + "has been disposed (SWT bug?)"); //$NON-NLS-1$ //$NON-NLS-2$
        	setup();
        }
        
        return cursor_;
    }

    /**
     * J[\̒xs܂B
     */
    private void setup() {
        ImageData imageData = getImageData();
        if (imageData == null) {
            log_s_.warn("Can't find image [" + key_ + "] use MissingImage.");  //$NON-NLS-1$//$NON-NLS-2$
            imageData = ImageDescriptor.getMissingImageDescriptor().getImageData();
        }
        cursor_ = new Cursor(
                Display.getCurrent(),
                imageData,
                hotspot_.x, hotspot_.y);

        if (cursorMap_s_.isEmpty()) {
            Display.getDefault().getActiveShell().addDisposeListener(disposeListener_s_);
        }
        cursorMap_s_.put(key_, cursor_);
    }
}
