/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.jface;

import java.io.File;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * {@link #getElements(Object)}̈{@link java.io.File}ƂA
 * ̒̃t@C(tH_[͏)ԂvoC_[łB
 * {@link java.io.File}ȊOAtH_[ȊOw肵ꍇ́A
 * vf0̔zԂ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class FileListContentProvider implements IStructuredContentProvider {

	/**
	 * 
	 */
	public FileListContentProvider() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {
		if (inputElement instanceof File) {
			File file = (File)inputElement;
			if (file.isDirectory()) {
				return file.listFiles();
			}
		}
		return new Object[0];
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
		// sv
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		// sv
	}
}
