/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.jface;

import java.io.File;

import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;

/**
 * ͂Ƃ{@link java.io.File}󂯎t@CԂvoC_[łB
 * ȊO̓͂ɂĂ͐e{@link org.eclipse.jface.viewers.LabelProvider}Ăяo܂B
 * 
 * ACRɂĂOSAvP[Vɍ킹ACR\܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class FileNameLabelProvider extends LabelProvider {
	static private final ImageResource IMG_FOLDER
			= new ImageResource(FileNameLabelProvider.class, "folder.png");  //$NON-NLS-1$
	/**
	 * 
	 */
	public FileNameLabelProvider() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.LabelProvider#getImage(java.lang.Object)
	 */
	@Override
	public Image getImage(Object element) {
		if (element instanceof File) {
			File file = (File)element;
			if (file.isDirectory()) {
				return IMG_FOLDER.get();
			}
			String ext = FilenameUtils.getExtension(file.getPath());
			Image image = ImageResource.get(FileNameLabelProvider.class, ext);
			if (image != null) {
				return image;
			}
			Program program = Program.findProgram(ext);
			if (program != null) {
				ImageData data = program.getImageData();
				if (data != null) {
					ImageResource.put(FileNameLabelProvider.class, ext, data);
					return ImageResource.get(FileNameLabelProvider.class, ext);
				}
			}
		}
		return super.getImage(element);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.LabelProvider#getText(java.lang.Object)
	 */
	@Override
	public String getText(Object element) {
		if (element instanceof File) {
			File file = (File)element;
			return file.getName();
		}
		return super.getText(element);
	}
}
