/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.jface;

import java.io.File;
import java.io.FileFilter;
import java.text.Collator;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.io.filefilter.TrueFileFilter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import org.unitarou.io.Ios;
import org.unitarou.ml.MessageResource;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;

/**
 * P̃tH_[̃t@C\{@link org.eclipse.jface.viewers.TableViewer}łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class FilesTableViewer implements WidgetContainer {
	
	/**
	 * ut@Cv
	 */
	static private final MessageResource LB_FILENAME
			= new MessageResource(FilesTableViewer.class, "lbFilename"); //$NON-NLS-1$
	

	private File folder_;
	
	/**
	 * {@link #tableViewer_}쐬p̃tOł
	 */
	private final int tvFlag_;
	
	
	private TableViewer tableViewer_;
	
	
	private FileFilter fileFilter_;
	
	/**
	 * {@link #tableViewer__}̃tH[JX؂ւƂO
	 * ʒm邽߂̃Xi[ێ܂B
	 */
	private final Set<FileFolderListener> listeners_;

	/**
	 * 
	 *
	 */
	public FilesTableViewer() {
		this(SWT.SINGLE | SWT.BORDER | SWT.FULL_SELECTION);
	}


	/**
	 * 
	 */
	public FilesTableViewer(int swtFlag) {
		super();
		tvFlag_ = swtFlag;
		
		folder_ = Ios.getCurrentDirectory();
		tableViewer_ = null;
		fileFilter_ = TrueFileFilter.INSTANCE;
		listeners_ = new HashSet<FileFolderListener>();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
	 */
	public Control createContents(Composite parent) {
		ArgumentChecker.throwIfNull(parent);
		tableViewer_ = new TableViewer(parent, tvFlag_);
		
		Table table = tableViewer_.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		TableColumn column = new TableColumn(table, SWT.NONE);
		column.setText(LB_FILENAME.get());
		column.setWidth(200);//TODO }WbNio[
		tableViewer_.setContentProvider(new FileListContentProvider());
		tableViewer_.setLabelProvider(new FileAnnotationLabelProvider());
		tableViewer_.addFilter(new ViewerFilterImpl());
		tableViewer_.setSorter(new ViewerSorterImpl());
		tableViewer_.setInput(folder_);
		
		TableViewersListener listener = new TableViewersListener();
		tableViewer_.addPostSelectionChangedListener(listener);
		tableViewer_.addDoubleClickListener(listener);
		return tableViewer_.getControl();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#dispose()
	 */
	public void dispose() {
		// sv
	}
	
	/**
	 * ݑIĂtH_[Ԃ܂B
	 * <code>null</code>͕Ԃ܂B
	 * @return
	 */
	public File getFolder() {
		return folder_;
	}

	/**
	 * 
	 * @param folder
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 * @throws IllegalArgumentException fBNg[ƔFłȂꍇ
	 */
	public void setFolder(File folder) {
		ArgumentChecker.throwIfNull(folder);
		if (!folder.isDirectory()) {
			throw new IllegalArgumentException("Parameter \'folder\' must be a directory: " + folder.getPath()); //$NON-NLS-1$
		}
		folder_  = folder;
		if (tableViewer_ != null) {
			tableViewer_.setInput(folder_);
		}
	}
	
	/**
	 * 
	 * @param fileFilter
	 */
	public void setFileFilter(FileFilter fileFilter) {
		ArgumentChecker.throwIfNull(fileFilter);
		fileFilter_ = fileFilter;
		tableViewer_.refresh();
	}

	/**
	 * Xi[ǉ܂Bnullłɓo^Ăꍇ͉܂B
	 * @param listener
	 */
	public void addListener(FileFolderListener listener) {
		if (listener == null) {
			return;
		}
		listeners_.add(listener);
	}
	
	/**
	 * Xi[폜܂B
	 * @param listener
	 */
	public void removeListener(FileFolderListener listener) {
		listeners_.remove(listener);
	}

	/**
	 * {@link FilesTableViewer#tableViewer_}ɓo^郊Xi[łB
	 * R[h̃NbN({I)ƃ_uNbNtbN܂B
	 */
	private class TableViewersListener 
			implements ISelectionChangedListener, IDoubleClickListener 
	{

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
		 */
		public void selectionChanged(SelectionChangedEvent event) {
			Object[] objs = ((IStructuredSelection)event.getSelection()).toArray();
			
			if (objs == null) {
				objs = new Object[0];
			}
			File[] files = new File[objs.length];
			System.arraycopy(objs, 0, files, 0, files.length);
			for (FileFolderListener listener : listeners_) {
				listener.filesFocused(files);
			}
		}

		/**
		 * tH_[_uNbNꂽꍇ{@link FolderListener#folderChanged(File)}A
		 * t@C_uNbNꂽꍇ{@link FileFolderListener#filesDoubleClicked(File)}
		 * Ăяo܂B
		 * 
		 * @see org.eclipse.jface.viewers.IDoubleClickListener#doubleClick(org.eclipse.jface.viewers.DoubleClickEvent)
		 */
		public void doubleClick(DoubleClickEvent event) {
			File file = (File)((IStructuredSelection)event.getSelection()).getFirstElement();
			
			if (file.isDirectory()) {
				for (FileFolderListener listener : listeners_) {
					listener.folderChanged(file);
				}
				folder_ = file;
				return;
			}
			
			for (FileFolderListener listener : listeners_) {
				listener.filesDoubleClicked(file);
			}
		}
	}
	
	/**
	 * tH_{@link FilesTableViewer#setFileFilter(FileFilter)}
	 * }b`vf̂ݎctB^[łB
	 */
	private class ViewerFilterImpl extends ViewerFilter {

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ViewerFilter#select(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		@Override
		public boolean select(Viewer viewer, Object parentElement, Object element) {
			if (element instanceof File) {
				File file = (File)element;
				return file.isDirectory() || fileFilter_.accept(file);
			}
			return false;
		}
		
	}
	
	/**
	 * tH_ƃt@CJeS[\[^[łB
	 */
	private class ViewerSorterImpl extends ViewerSorter {
		
		/**
		 * 
		 */
		public ViewerSorterImpl() {
			super();
		}

		/**
		 * @param collator
		 */
		public ViewerSorterImpl(Collator collator) {
			super(collator);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ViewerSorter#category(java.lang.Object)
		 */
		@Override
		public int category(Object element) {
			if (element instanceof File) {
				File file = (File)element;
				return file.isDirectory() ? 0 : 1;
			}			
			return super.category(element);
		}
	}
}
