/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.jface;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * {@link #inputChanged(Viewer, Object, Object)}{@link java.io.File}󂯎A
 * [gƂĂȉ̃fBNĝ݂ԂRecvoC_łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class FolderTreeContentProvider implements ITreeContentProvider {

	
	/**
	 * JgfBNgZbg܂B
	 */
	public FolderTreeContentProvider() {
		super();
	}

	/**
	 * parentElement̎qfBNg[݂̂܂Ƃ߂ĕԂ܂B
	 * parentElement{@link File}CX^XȊȌꍇ<code>null</code>Ԃ܂B
	 * 
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof File) {
			File[] files = ((File)parentElement).listFiles();
			if (files == null) {
				return null;
			}
			List<File> list = new ArrayList<File>(files.length);
			for (File child : files) {
				if (!child.equals(parentElement)
						&& child.isDirectory()) {
					list.add(child);
				}
			}
			return list.toArray(new File[list.size()]);
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) {
		if (element instanceof File) {
			File file = (File)element;
			return file.getParentFile();
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element) {
		if (element instanceof File) {
			File[] files = ((File)element).listFiles();
			if (files == null) {
				return false;
			}
			for (File child : files) {
				if (!child.equals(element)
						&& child.isDirectory()) {
					return true;
				}
			}
			return false;
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
		// ȂB
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		if (newInput == null) {
			return;
		}
		if (!(newInput instanceof File)) {
			throw new IllegalArgumentException("Bad input: " + newInput); //$NON-NLS-1$
		}
	}
}
