/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.jface;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

import org.unitarou.io.Ios;
import org.unitarou.ml.MessageResource;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;

/**
 * tH_[c[񋟂{@link org.eclipse.jface.viewers.TreeViewer}łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class FolderTreeViewer implements WidgetContainer {
	
	static private final ImageResource IMG_UP_NAVI
			= new ImageResource(FolderTreeViewer.class, "upNavi.png"); //$NON-NLS-1$

	static private final ImageResource IMG_UP_NAVI_D
			= new ImageResource(FolderTreeViewer.class, "upNaviD.png"); //$NON-NLS-1$

	static private final ImageResource IMG_DOWN_NAVI
			= new ImageResource(FolderTreeViewer.class, "downNavi.png"); //$NON-NLS-1$

	static private final ImageResource IMG_DOWN_NAVI_D
			= new ImageResource(FolderTreeViewer.class, "downNaviD.png"); //$NON-NLS-1$

	static private final ImageResource IMG_DRIVE
			= new ImageResource(FolderTreeViewer.class, "drive.png"); //$NON-NLS-1$
	
	/** uhCu؂ւv*/
	static private final MessageResource NT_TT_CHANGEDRIVE
			= new MessageResource(FolderTreeViewer.class, "ntTtChangedrive"); //$NON-NLS-1$

	/** ũtH_[{0}]ցv*/
	static private final MessageResource NT_TT_UPFOLDER
			= new MessageResource(FolderTreeViewer.class, "ntTtUpfolder"); //$NON-NLS-1$

	/** ũtH_[{0}]ցv*/
	static private final MessageResource NT_TT_DOWNFOLDER
			= new MessageResource(FolderTreeViewer.class, "ntTtDownfolder"); //$NON-NLS-1$

	/** uhCu̐؂ւɎs܂v*/
	static private final MessageResource NT_TITLE_FAILURE_CHANGEDRIVE
			= new MessageResource(FolderTreeViewer.class, "ntTitleFailureChangedrive"); //$NON-NLS-1$
	
	/** uhCu{0}ɐ؂ւ܂łB\nhCuڑĂȂ悤łBv*/
	static private final MessageResource MSG_FAILURE_CHANGEDRIVE
			= new MessageResource(FolderTreeViewer.class, "msgFailureChangedrive"); //$NON-NLS-1$

	/**
	 * ݂̊fBNg[ێ܂B
	 * {@link TreeViewer}ł͂艺\܂B
	 */
	private File root_;
	
	/**
	 * plŜێt[łB 
	 */
	private Composite frame_;
	
	/**
	 * ŏ(WindowsƃhCu)؂ւׂ
	 */
	private ToolItem tiRoots_;

	/**
	 * ̃tH_ɐiރc[{^łB
	 */
	private ToolItem tiUpNavi_;
	
	/**
	 * ̃tH_ɐiރc[{^łB
	 */
	private ToolItem tiDownNavi_;
	
	/**
	 * {@link #tiDownNavi_}{@link #treeViewer_}AXi[łB
	 */
	private final DownNaviSelectionListener listener_;

	
	/**
	 * {@link #root_}̐efBNg[܂ł̐΃pX\郉xłB
	 */
	private CLabel clbRoot_;
	
	
	/**
	 * {@link #root_}ȉ̃fBNg[\TreeViewerłB
	 */
	private TreeViewer treeViewer_;
	
	/**
	 * {@link #treeViewer_}̃tH[JX؂ւƂO
	 * ʒm邽߂̃Xi[ێ܂B
	 */
	private final Set<FolderListener> listeners_;

	/**
	 * ݒڂĂfBNgłB 
	 */
	private File folder_;
	
	
	/**
	 * fBNg[JgfBNg[ɐݒ肵܂B 
	 */
	public FolderTreeViewer() {
		super();
		root_ = new File(".").getAbsoluteFile().getParentFile(); //$NON-NLS-1$
		tiRoots_ = null;
		tiUpNavi_ = null;
		tiDownNavi_ = null;
		listener_ = new DownNaviSelectionListener();
		clbRoot_ = null;
		treeViewer_ = null;
		listeners_ = new HashSet<FolderListener>();
		folder_ = root_;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
	 */
	public Control createContents(Composite parent) {
		ArgumentChecker.throwIfNull(parent);
		
		frame_ = new Composite(parent, SWT.NONE);
		frame_.setLayout(new GridLayout(1, false));
		final ToolBar toolBar = new ToolBar(frame_, SWT.FLAT);

		final Menu menu = createRootsMenu(parent.getShell());
		final ToolItem item = new ToolItem(toolBar, SWT.DROP_DOWN);
		item.setToolTipText(NT_TT_CHANGEDRIVE.get());
		item.setImage(IMG_DRIVE.get());
		item.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				if (event.detail == SWT.ARROW) {
					Rectangle rect = item.getBounds();
					Point pt = new Point(rect.x, rect.y + rect.height);
					pt = toolBar.toDisplay(pt);
					menu.setLocation(pt.x, pt.y);
					menu.setVisible(true);
				}
			}
		});
		
		tiUpNavi_ = new ToolItem(toolBar, SWT.PUSH);
		tiUpNavi_.setImage(IMG_UP_NAVI.get());
		tiUpNavi_.setDisabledImage(IMG_UP_NAVI_D.get());
		tiUpNavi_.addSelectionListener(new UpNaviSelectionListener());
		
		tiDownNavi_ = new ToolItem(toolBar, SWT.PUSH);
		tiDownNavi_.setImage(IMG_DOWN_NAVI.get());
		tiDownNavi_.setDisabledImage(IMG_DOWN_NAVI_D.get());
		tiDownNavi_.addSelectionListener(listener_);
		tiDownNavi_.setEnabled(false);
		toolBar.pack();
		

		clbRoot_ = new CLabel(frame_, SWT.LEFT);
		clbRoot_.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, true, false));
		
		treeViewer_ = new TreeViewer(frame_, SWT.SINGLE | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		treeViewer_.setContentProvider(new FolderTreeContentProvider());
		treeViewer_.setLabelProvider(new FileNameLabelProvider());
		treeViewer_.getControl().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		treeViewer_.addPostSelectionChangedListener(listener_);
		rootChanted();
		return frame_;
	}
	

	private Menu createRootsMenu(Shell shell) {
		RootsSelectionListener listener = new RootsSelectionListener();
		Menu menu = new Menu(shell, SWT.POP_UP);
		for (File file : File.listRoots()) {
			MenuItem item = new MenuItem(menu, SWT.RADIO);
			item.setText(file.getPath()); 
			item.setData(file);
			item.setImage(IMG_DRIVE.get());
			item.addSelectionListener(listener);
			if (root_.getPath().startsWith(file.getPath())) {
				item.setSelection(true);
			}
		}
		return menu;
	}

	/**
	 * {@link #root_}ύXꂽŌĂяo܂B
	 * \nύXɍ킹čXV܂B
	 */
	private void rootChanted() {
		clbRoot_.setText(root_.getPath());
		
		if (treeViewer_ != null) {
			treeViewer_.setInput(root_);
			treeViewer_.setSelection(new StructuredSelection(folder_), true);
		}
		
		tiUpNavi_.setEnabled(root_.getParentFile() != null);
		if (tiUpNavi_.isEnabled()) {
			tiUpNavi_.setToolTipText(NT_TT_UPFOLDER.get(root_.getParent()));
		}
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#dispose()
	 */
	public void dispose() {
		// ɉȂB
	}
	
	/**
	 * ̃pl̍ŏʂ̃Rg[Ԃ܂B
	 * @return
	 */
	public Control getControl() {
		return frame_;
	}
	
	/**
	 * ݂̃c[̃[gtH_Ԃ܂B
	 * @return ݂̃c[̃[gtH_
	 */
	public File getRoot() {
		return root_;
	}
	
	/**
	 * ݒڂĂfBNg[Ԃ܂B
	 * @return
	 */
	public File getFolder() {
		return folder_;
	}

	/**
	 * c[̃[gݒ肵܂B
	 * @param newRoot
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 * @throws IllegalArgumentException fBNg[ƔFłȂꍇ
	 */
	public void setRoot(File newRoot) {
		ArgumentChecker.throwIfNull(newRoot);
		if (!newRoot.isDirectory()) {
			throw new IllegalArgumentException("Parameter must be a directory: " + newRoot.getPath()); //$NON-NLS-1$
		}
		root_ = newRoot;
		if (!Ios.isChild(root_, folder_)) {
			folder_ = root_;
		}
		rootChanted();
	}
	
	/**
	 * ڂtH_[ړ܂B
	 * [g({@link #root_})̈ړ͍sȂ̂ŒӁB
	 * 
	 * @param newFolder
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 * @throws IllegalArgumentException fBNg[ƔFłȂꍇ
	 */
	public void setFolder(File newFolder) {
		ArgumentChecker.throwIfNull(newFolder);
		if (!newFolder.isDirectory()) {
			throw new IllegalArgumentException("Parameter must be a directory: " + newFolder.getPath()); //$NON-NLS-1$
		}
		folder_  = newFolder;
		String cr = Ios.calcCommonRoot(root_, folder_);
		if (cr != null) {
			root_ = new File(cr);
		} else {
			root_ = folder_;
		}
		rootChanted();
	}

	/**
	 * Xi[ǉ܂Bnullłɓo^Ăꍇ͉܂B
	 * @param listener
	 */
	public void addListener(FolderListener listener) {
		if (listener == null) {
			return;
		}
		listeners_.add(listener);
	}
	
	/**
	 * Xi[폜܂B
	 * @param listener
	 */
	public void removeListener(FolderListener listener) {
		listeners_.remove(listener);
	}
	
	
	/**
	 * {@link FolderTreeViewer#tiRoots_}ɑΉ郁j[
	 * NbNꂽƂɌĂяo郊Xi[łB 
	 */
	private class RootsSelectionListener extends SelectionAdapter {

		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		@Override
		public void widgetSelected(SelectionEvent e) {
			// j[쐬dataɓĂB
			File file = (File)e.widget.getData();
			if (file.canRead()) {
				root_ = file;
				rootChanted();
				return;
			}
			
			// ǂݍ߂Ȃꍇ́Aj[̐؂ւɖ߂
			// xbZ[W[UɏoB
			MenuItem menuItem = (MenuItem)e.widget;
			menuItem.setSelection(false);
			Menu menu =  menuItem.getParent();
			for (MenuItem item : menu.getItems()) {
				if (item.getData().equals(root_)) {
					item.setSelection(true);
					break;
				}
			}
			MessageDialog.openWarning(
					clbRoot_.getShell(), 
					NT_TITLE_FAILURE_CHANGEDRIVE.get(), 
					MSG_FAILURE_CHANGEDRIVE.get(file.getPath()));
		}
	}
	
	/**
	 * {@link FolderTreeViewer#tiUpNavi_}NbNꂽƂɌĂяo郊Xi[łB
	 */
	private class UpNaviSelectionListener extends SelectionAdapter  {
		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		@Override
		public void widgetSelected(SelectionEvent e) {
			root_ = root_.getParentFile();
			rootChanted();
		}
	}

	/**
	 * {@link FolderTreeViewer#tiDownNavi_}NbNꂽƂɌĂяo郊Xi[łB
	 */
	private class DownNaviSelectionListener 
			extends SelectionAdapter implements ISelectionChangedListener 
	{
		/**
		 * ɐiނƂɌĂяo܂B
		 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		@Override
		public void widgetSelected(SelectionEvent e) {
			if ((folder_ != null) 
				&& (folder_.getParentFile() != null)){
				root_ = folder_.getParentFile();
				rootChanted();
			}
		}

		/**
		 * {@link FolderTreeViewer#treeViewer_}
		 * ڂm[hύXꂽɌĂяo܂B
		 * 
		 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
		 */
		public void selectionChanged(SelectionChangedEvent event) {
			IStructuredSelection selection = (IStructuredSelection)event.getSelection();
			File newfolder = (File)selection.getFirstElement();
			
			if ((newfolder == null) || !newfolder.canRead()) {
				tiDownNavi_.setEnabled(false);
				return;
			}
			folder_ = newfolder;

			boolean hasChild = false;
			for (File file : folder_.listFiles()) {
				if (file.isDirectory()) {
					hasChild = true;
					break;
				}
			}
			tiDownNavi_.setEnabled(hasChild);
			if (hasChild) {
				tiDownNavi_.setToolTipText(NT_TT_DOWNFOLDER.get(folder_.getName()));
			}
			
			for (FolderListener listener : listeners_) {
				listener.folderChanged(folder_);
			}
		}
	}
}
