/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.jface;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

import org.unitarou.util.ArgumentChecker;


/**
 * TCYAX^C̈قȂtHgꌳǗ郊\[XłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class FontResource {
    static private final FontRegistry fontRegistry_s_ = JFaceResources.getFontRegistry();

    /**
     * {@link #fontRegistry_s_}po^L[쐬ۂ̋؂qłB
     * ۂ̒l̓A_[XRA[('_')łB
     * OƃTCYƃX^C̊Ԃɓ܂B
     */
    static private final char DELIMITER = '_';
    
    static private final FontData DEFAULT = new FontData();
    

    private final String fontName_;
    private final int defaultHeight_;
    private final int defaultStyle_;
    private final String defaultKey_;
    
    /**
     * OS̃ftHgtHgŏ܂B
     * @param height
     * @param style
     */
    public FontResource(int height, int style) {
        fontName_ = DEFAULT.getName();
        defaultHeight_ = height;
        defaultStyle_ = style;
        defaultKey_ = makeKey(fontName_, defaultHeight_, defaultStyle_);
        if (!fontRegistry_s_.hasValueFor(defaultKey_)) {
            fontRegistry_s_.put(defaultKey_,
                    new FontData[]{new FontData(fontName_, defaultHeight_, defaultStyle_)});
        }   	
    }
    /**
     * @param symbolicName tHgw肵܂B
     * @param height tHg̃TCYsNZŎw肵܂B
     * @param style tHg̃X^CA{@link SWT#NORMAL}, 
     *         {@link SWT#BOLD}, {@link SWT#ITALIC}ȂǂŎ܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public FontResource(String symbolicName, int height, int style) {
        super();
        ArgumentChecker.throwIfNull(symbolicName);

        fontName_ = symbolicName;
        defaultHeight_ = height;
        defaultStyle_ = style;
        defaultKey_ = makeKey(fontName_, defaultHeight_, defaultStyle_);
        if (!fontRegistry_s_.hasValueFor(defaultKey_)) {
            fontRegistry_s_.put(defaultKey_,
                    new FontData[]{new FontData(fontName_, defaultHeight_, defaultStyle_)});
        }
    }
    
    private String makeKey(String fontName, int height, int style) {
        // +37(FQCN +_ + _ + (2) _ + (N|B|I|BI))	
        StringBuilder sb = new StringBuilder(fontName.length() + 40);
        sb.append(this.getClass().getName()).append(DELIMITER);
        sb.append(fontName).append(DELIMITER);
        sb.append(height).append(DELIMITER);
        if (style == SWT.NORMAL) {
            sb.append('N');
        } else {
            if (0 != (style & SWT.BOLD)) {
                sb.append('B');
            } 
            if (0 != (style & SWT.ITALIC)) {
                sb.append('I');
            }
        }
        return sb.toString();
    }
    
    /**
     * @return
     */
    public Font get() {
        return fontRegistry_s_.get(defaultKey_);
    }
    
    
    /**
     * height(rbg)̃tHgԂ܂B
     * @param height
     * @return
     */
    public Font get(int height) {
        if (height == defaultHeight_) {
            return get();
        }
        if (height <= 0) {
            //
            return get();
        }
        
        String key = makeKey(fontName_, height, defaultStyle_);
        if (!fontRegistry_s_.hasValueFor(key)) {
            fontRegistry_s_.put(key,
                    new FontData[]{new FontData(fontName_, height, defaultStyle_)});
        }
        Font font = fontRegistry_s_.get(key);
        return font;
    }
    
    /**
     * gc̃ReLXgtextdiameter𒼌aƂ~̘gɎ܂ő̃tHgԂ܂B
     * @throws org.unitarou.lang.NullArgumentException@gctextnull̏ꍇ
     */
    public Font getInCircle(GC gc, String text, int diameter) {
        ArgumentChecker.throwIfNull(gc, text);

        gc.setFont(get());
        int oldH = gc.getFont().getFontData()[0].getHeight();
        Point p = gc.textExtent(text); 
        int newHeight = (int)(oldH * (double)diameter / (Math.max(p.x, p.y) * 1.4142));
        if (newHeight <= 0) {
            newHeight = 1;
        }
        return get(newHeight);

    }
    
    /**
     * gc̃ReLXgtextsize̋`Ɏ܂ő̃tHgԂ܂B
     * @throws org.unitarou.lang.NullArgumentException@gctextnull̏ꍇ
     */
    public Font getInRect(GC gc, String text, Point size) {
        ArgumentChecker.throwIfNull(gc, text);

        gc.setFont(get());
        int oldH = gc.getFont().getFontData()[0].getHeight();
        Point p = gc.textExtent(text); 
        double newRatio = Math.min((double)size.x / p.x, (double)size.y / p.y);
        
        int newHeight = (int)(oldH * newRatio);
        if (newHeight <= 0) {
            newHeight = 1;
        }
        return get(newHeight);
    }
}
