/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.jface;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

import org.unitarou.lang.Classes;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link org.eclipse.swt.graphics.Image}pɁA
 * o^L[ƃ\[XێNXłB
 * {@link #get()}A{@link #getImageData()}ŕԂ
 * IuWFNgImageResitoryŊǗ̂dispose͕svłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class ImageResource {
    /**
     * JFaceResourcesǗĂC[WWXg[łB
     * CX^X̓C[W̓o^ɂ̃WXg[g܂B
     */
    static private final ImageRegistry imageRegistry_s_ = JFaceResources.getImageRegistry();
    
    /**
     * CX^Xs킸ɒڃC[WWXgɓo^܂B<br>
     * CX^XێɁAkeyłꍇɗp܂B
     * 
     * @param clazz
     * @param key
     * @param data
     */
    static public void put(Class clazz, String key, ImageData data) {
        ArgumentChecker.throwIfNull(clazz, key, data);
        
        String ck = Classes.uniqueKey(clazz, key);
        imageRegistry_s_.put(ck, ImageDescriptor.createFromImageData(data));
    }
    
    static public Image get(Class clazz, String key) {
        ArgumentChecker.throwIfNull(clazz, key);
        return imageRegistry_s_.get(Classes.uniqueKey(clazz, key));
    }

    /** ̃CX^XێĂ郊\[X̃L[łB */
    protected final String key_;
    

    /**
     * clazẑpbP[WɃ\[Xt@C邱ƂOƂ܂B
     * @param clazz L[͂̃NXxŃj[NɂȂ܂B
     * @param filename \[X̃t@CłB
     * 
     * @throws org.unitarou.lang.NullArgumentException ̉ꂩłnull̏ꍇB
     */
    public ImageResource(Class<?> clazz, String filename) {
        super();
        ArgumentChecker.throwIfNull(clazz, filename);

        key_ = Classes.uniqueKey(clazz, filename);
        imageRegistry_s_.put(key_, ImageDescriptor.createFromFile(clazz, filename));
    }
    
    /**
     * ImageԂ܂BԂImagedisposesvłB
     */
    public Image get() {
        return imageRegistry_s_.get(key_);
    }
    
    public ImageData getImageData() {
        return imageRegistry_s_.getDescriptor(key_).getImageData(); 
    }
}
