/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.jface;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

import org.unitarou.lang.Strings;
import org.unitarou.util.ArgumentChecker;

/**
 * ^CgbZ[WȂǂOw\ɂ_CAOłB
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class UTitleAreaDialog extends TitleAreaDialog {

	/**
	 * {@link org.eclipse.swt.widgets.Decorations#setText(java.lang.String)}
	 * {@link #createContents(Composite)}ŌĂяo悤ɒlێ܂B
	 */
	private String shellTitle_;
	
	/**
	 * {@link TitleAreaDialog#setTitle(java.lang.String)}
	 * {@link #createContents(Composite)}ŌĂяo悤ɒlێ܂B
	 */
	private String title_;

	/**
	 * @param parentShell
	 */
	public UTitleAreaDialog(Shell parentShell) {
		super(parentShell);
		shellTitle_ = Strings.EMPTY;
		title_ = Strings.EMPTY;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.TitleAreaDialog#createContents(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createContents(Composite parent) {
		Control control =  super.createContents(parent);
		getShell().setText(shellTitle_);
		super.setTitle(title_);
        return control;
	}

	/**
	 * EBhẼ^Cgw肵܂B
	 * @param text
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇB
	 */
	public void setShellTitle(String newTitle) {
		ArgumentChecker.throwIfNull(newTitle);
		shellTitle_ = newTitle;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.TitleAreaDialog#setTitle(java.lang.String)
	 */
	@Override
	public void setTitle(String newTitle) {
		ArgumentChecker.throwIfNull(newTitle);
		title_ = newTitle;
	}

}
