/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.lang;

import org.unitarou.util.ArgumentChecker;


/**
 * ClassNXɑ΂郆[eBeBłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class Classes {
    /** pbP[W؂Zp[^'.'łB*/
	static private final char SEPARATOR = '.'; 
	
	/** \bh̎OɂZp[^'#'łB*/
	static private final char METHOD_SEPARATOR = '#';

	/** IuWFNg̃nbVR[h̎OɂZp[^'/'łB*/
	static private final char OBJECT_SEPARATOR = '/';

	/**
	 * NXpbP[WĕԂ܂B
	 * 
	 * @throws NullArgumentException null̏ꍇB
	 */
	static public String simpleName(Class<?> clazz) {
		ArgumentChecker.throwIfNull(clazz);
		return simpleName(clazz.getName());
	}
	
	/**
	 * classNameNX(FQCN)Ƃ݂ȂăpbP[WOԂ܂B
	 * 
	 * @throws NullArgumentException null̏ꍇB
	 */
	static public String simpleName(String className) {
		ArgumentChecker.throwIfNull(className);
		int index = className.lastIndexOf(SEPARATOR);
		return className.substring(index + 1);
	}

	/**
	 * {@link Class#getName()} clazz̃pbP[WԂ܂B
	 * {@link Class#getPackage()}nullԂ悤ȏ󋵂łA
	 * pbP[WԂ܂B
	 * ftHgpbP[W̏ꍇ͋󕶎Ԃ܂B
	 * 
	 * @throws NullArgumentException null̏ꍇB
	 */
	static public String packageName(Class<?> clazz) {
		ArgumentChecker.throwIfNull(clazz);
	    String name = clazz.getName();
		int packageEndIdx = name.lastIndexOf(SEPARATOR);
		String packageName 
			= (0 <= packageEndIdx) 
				? name.substring(0, packageEndIdx) 
				: Strings.EMPTY;
		return packageName;
	}
	
	/**
	 * NX[_ŜŃj[NȃL[쐬܂B
	 * ̓Iɂobject{@link Class#getName()} 
	 *   + '/' + object̂PUinbVR[h + '#' + key Ԃ܂B
	 * 
	 * @throws NullArgumentException null̏ꍇB
	 */
	static public String uniqueKey(Object object, String key) {
		ArgumentChecker.throwIfNull(object, key);
	    StringBuilder sb = new StringBuilder();
	    sb.append(object.getClass().getName());
	    sb.append(OBJECT_SEPARATOR).append(Integer.toString(System.identityHashCode(object), 16));
	    sb.append(METHOD_SEPARATOR).append(key);
	    return sb.toString();
	}

	/**
	 * NX[_ŜŃj[NȃL[쐬܂B
	 * ̓Iɂclazz{@link Class#getName()} + '#' + key Ԃ܂B
	 * 
	 * @throws NullArgumentException null̏ꍇB
	 */
	static public String uniqueKey(Class<?> clazz, String key) {
		ArgumentChecker.throwIfNull(clazz, key);
	    StringBuilder sb = new StringBuilder();
	    sb.append(clazz.getName());
	    sb.append(METHOD_SEPARATOR).append(key);
	    return sb.toString();
	}

	/** \bhNXȂ̂ŌČĂяo܂B*/
	protected Classes() {/* empty */ }
}
