/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.lang;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * \bhŏo郍ÕAme[VłB
 * o郍OꌏƂɎw肵܂B
 * P\bhŕx̃OoĂꍇ
 * {@link org.unitarou.lang.Loggings}p܂B<br>
 *  
 * O̐ݒt@C쐬ۂ̎QlƂėp邱Ƃz肵Ă̂ŁA
 * ʂɕKoO(ÕLb`FATAL, ERROR, WARNȂ)ɂĂ
 * Ame[VsvłAaptŃtB^[Ώ\ł̂ŁA
 * \Ȍ悤ɂ܂傤B
 */
@Documented
@Retention(RetentionPolicy.SOURCE)
@Target({ElementType.CONSTRUCTOR, ElementType.METHOD})
public @interface Logging {
	
	/**
	 * {@link Logging#level()}ŕԂ郍OxłB
	 */
	public enum Level {
		FATAL,
		ERROR,
		WARN,
		INFO,
		DEBUG,
		TRACE;
	}

	/**
	 * L^郍ÕxԂ܂B
	 */
	Logging.Level level();
	
	/**
	 * OɋL^܂ȓeԂ܂B
	 */
	String contents() default Strings.EMPTY;
	
	/**
	 * <code>true</code>̏ꍇAOɃX^bNg[X
	 * L^邱ƂӖ܂B
	 */
	boolean stackTrace() default false;
}