/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.lang;

/**
 * \bḧ<code>null</code>̏ꍇɑo関`FbN̗OłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class NullArgumentException extends IllegalArgumentException {
    
    /**
	 * 
	 */
	private static final long serialVersionUID = 8825423054594209326L;

	/**
	 * parametersG[bZ[W\܂B
	 * @param parameters
	 * @return
	 */
	static private String composeMessage(Object[] parameters) {
		if (parameters == null) {
			return null;
		}
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append("A part of parameters is null {"); //$NON-NLS-1$
		for (int i = 0; i < parameters.length; ++i) {
			stringBuilder.append("arg").append(i + 1) //$NON-NLS-1$
						. append(" is ").append(parameters[i]); //$NON-NLS-1$
			if (i != (parameters.length - 1)) {
				stringBuilder.append(", "); //$NON-NLS-1$
			}
		}
		stringBuilder.append("}"); //$NON-NLS-1$
		return stringBuilder.toString();
	}

	public NullArgumentException() {
		super();
	}

	public NullArgumentException(String s) {
		super(s);
	}
	
	/**
	 * parameterŝЂƂȏ̗vfnull̎ɁA
	 * {Ooۂɗp܂B<br>
	 * bZ[W"A part of parameters is null {vf1:vf2:...}"̌`ŁA
	 * parameters̑Svfǉ܂B
	 * parametersnull̏ꍇ̓bZ[WnullɂȂ܂B
	 */
	public NullArgumentException(Object... parameters) {
		super(composeMessage(parameters));
	}
}
