/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.lang;

/**
 * {@link java.lang.Runtime}Ɋ֘A\bhNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class Runtimes {

    /**
     *  p\[oCgŕԂ܂B
     * ۂɂ{@link Runtime#maxMemory()} 
     *           - ({@link Runtime#totalMemory()} - {@link Runtime#freeMemory())}ƓłB 
     */
    static public long availableMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory());
    }
    
    /**
     * {@link Runtime#freeMemory()}ȂǂŕԂoCgPʂ̐lMBPʂɕϊĕԂ܂B
     * l͎ľܓ܂B
     */
    static public long byteToMegabyte(long byteValue) {
        return (long)(0.5 + (double)byteValue / (1024 * 1024));
    }
    
    /**
     * ݂̃XbhɂlevelŎw肳ꂽ[܂ł
     * X^bNg[Xš`ŕԂ܂B
     * @param level
     * @return
     */
    static public String formatStackTrace(int level) {
    	
    	//MEMO 4̓X^bNg[X\ۂɂ͕svȃ\bh̐
    	StringBuilder ret = new StringBuilder();
    	StackTraceElement[] elements = Thread.currentThread().getStackTrace();
    	for (int i = 4; i < 4 + level; ++i) {
    		StackTraceElement element = elements[i];
    		ret.append(Classes.simpleName(element.getClassName())).append('#').append(element.getMethodName())
    		   .append("()@").append(element.getLineNumber()); //$NON-NLS-1$
    		
    		if (i != level + 3) {
    			ret.append(" <= "); //$NON-NLS-1$ 
    		}
    	}
     	
    	return ret.toString();
    }
     
    /**
     * 
     */
    protected Runtimes() {
        super();
    }
}
