/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.lang;

import java.nio.charset.Charset;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

import org.unitarou.util.ArgumentChecker;

/**
 * StringɊ֌WʃtB[hA\bhW߂X^eBbNNXłB
 * ̉邱Ƃ͂ł܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class Strings {
	/** 󕶎łB*/
	static public final String EMPTY = ""; //$NON-NLS-1$
	
	/**
	 * l<code>null</code>ł邱ƂӖ镶g&lt;&lt;null&gt;&gt;hłB
	 */
	static public final String NULL_MARK = "<<null>>"; //$NON-NLS-1$

	/** OSˑ̋؂蕶łBsɂĒlς܂B*/
	static public final String LINE_SEPARATOR = System.getProperty("line.separator"); //$NON-NLS-1$
	
	/**
	 * US-ASCII̕R[hZbgłB
	 */
	static public final Charset CHARSET_US_ASCII = Charset.forName("US-ASCII"); //$NON-NLS-1$
	
	/**
	 * s1s2sR[h̃^Cv𖳎Ĕr܂B
	 * ႦequalsIgnoreEolType("A\r\nB","A\nB") == equalsIgnoreEolType("A\nB","A\rB") == truełB<br>
	 * "\r\n"=="\r"=="\n"łA"\n\r"=="\n\n"=="\r\r"=="\r\n\r\n"łB<br>
	 * Ȃs1,s2null̏ꍇtrueAǂ炩null̏ꍇfalseԂ܂B
	 *  
	 * @return s1s2sR[h̃^Cv𖳎ētrue
	 */
	static public boolean equalsIgnoreEolType(String s1, String s2) {
	    if (s1 == null) {
	        return s2 == null;

	    } else if (s2 == null){
	        return false;
	    }
	    CharacterIterator i1 = new StringCharacterIterator(s1);
	    CharacterIterator i2 = new StringCharacterIterator(s2);
	    
	    char c1 = i1.first();
	    char c2 = i2.first();
	    do {
	        // 1.CRꂽPɈꕶǂ݂āALFȊÔƂ͖߂B
	        if (c1 == '\r') {
	            c1 = i1.next();
	            if (c1 != '\n') {
	                c1 = i1.previous();
	            }
	        }
	        
	        if (c2 == '\r') {
	            c2 = i2.next();
	            if (c2 != '\n') {
	                c2 = i2.previous();
	            }
	        }

	        // 2.CRLF̈Ⴂ𖳎ĔrB
	        if ((c1 == '\r' || c1 == '\n')
	            && (c2 == '\r' || c2 == '\n')) {
	            c1 = i1.next();
	            c2 = i2.next();
	            continue;
	        }

	        // 3. sR[hȊO͕ʂɔr
	        if (c1 == c2) {
	            if (c1 == CharacterIterator.DONE) {
	                return true;
	            }
	            c1 = i1.next();
	            c2 = i2.next();
	            continue;
	        }

	        return false;

	    } while(true);
	}
	
    /**
     * c[}At@xbg̑啶̏ꍇtrueԂ܂B
     */
	static public boolean isUppercaseRomanAlphabet(char c) {
	    return ('A' <= c) && (c <= 'Z');
	}
	
	/**
	 * secondmm:sš`ɕϊ܂B
	 * <pre>
	 * 59  0:59
	 * 60  1:00
	 * 61  1:01
	 * 70  1:10
	 * </pre>
	 * 
	 * @param second
	 * @return
	 */
	static public String formatDuration(int second) {
		int min = second / 60;
		second = second % 60;
		
		StringBuilder sb = new StringBuilder();
		sb.append(min).append(':');
		if (second < 10) {
			sb.append('0');
		}
		sb.append(second);
		return sb.toString();
	}
	
	
	/**
	 * targetnull̏ꍇ{@link #NULL_MARK}ԂA
	 * ȊÔƂ͂̂܂܂̒lԂ܂B
	 * @param target
	 * @return
	 */
	static public String nullToNullMark(String target) {
		return (target != null) ? target : NULL_MARK;
	}
	
	
	/**
	 * string1string2̕ύXLSC(longest common subsequence)x[XŕԂ܂B
	 * @param string1
	 * @param string2
	 * @return
	 */
	static public int calcDiffSize(String string1, String string2) {
		ArgumentChecker.throwIfNull(string1, string2);
		return Math.max(string1.length(), string2.length())
				- calcLscLength(string1, string2);
	}
	
	
	/**
	 * string1string2LSC(longest common subsequence)Ԃ܂B
	 * 
	 * @param string1
	 * @param string2
	 * @return LSC(longest common subsequence)
	 * @throws NullArgumentException <code>null</code>̏ꍇ
	 */
	static public int calcLscLength(String string1, String string2) {
		ArgumentChecker.throwIfNull(string1, string2);
		if (string1.length() == 0 || string2.length() == 0) {
			return 0;
		}
		
		// cFstring1̊eAFstring2̊e̒iKł̈v
		int[][] hitTable = new int[string1.length() + 1][string2.length() + 1];
		
		int ret = 0;
		for (int idx1 = 1; idx1 < hitTable.length; ++idx1) {
			for (int idx2 = 1; idx2 < hitTable[idx1].length; ++idx2) {
				if (string1.charAt(idx1 - 1) == string2.charAt(idx2 - 1)) {
					hitTable[idx1][idx2] = hitTable[idx1 - 1][idx2 - 1] + 1;
				} else {
				    hitTable[idx1][idx2] = Math.max(
				    		hitTable[idx1-1][idx2], 
				    		hitTable[idx1][idx2-1]);
			    }
		    	ret = Math.max(ret, hitTable[idx1][idx2]);
		    }
		}
		return ret;
	}

	protected Strings() {
	    super();
	}
}
