/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.util.ArgumentChecker;

/**
 * 񋓌^\NXł('U'Java5EnumƋʂ邽)B<br>
 * RXgN^typeNaméANXŃj[NłKv܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
abstract public class UEnum implements Comparable {
	static private final Log log_s_ = LogFactory.getLog(UEnum.class);
	/** 
	 * ŏClass͗񋓌^̃NXłB 
	 * ComparabletypeNamełB
	 * ꂽSNXĂ܂B
	 */
	static private final Map<Class<? extends UEnum>, Map<Comparable<?>, UEnum>> 
			enumMap_s_ = new HashMap<Class<? extends UEnum>, Map<Comparable<?>, UEnum>>();
	static private final char SEPARATOR = ':';
	
	/**
	 * ɈvCX^XԂ܂B
	 * ݂Ȃꍇ<code>null</code>Ԃ܂B
	 * 唼̃NX̓NX[hɗ񋓎qo^̂ŁA
	 * vf̏ꍇ{@link Class#forName(java.lang.String)}ĂяoāA
	 * UNXǂݏo܂B
	 * @throws NullArgumentException nullꍇB
	 */
	static public UEnum find(Class<? extends UEnum> clazz, Comparable typeName) {
	    ArgumentChecker.throwIfNull(clazz, typeName);

	    Map<Comparable<?>, UEnum> map = getMapWithLoad(clazz, "UEnum#find");  //$NON-NLS-1$
		if (map != null) {
			return map.get(typeName);
		}
		return null;
	}
	
	/**
	 * clazzɊi[ĂS񋓎q̔zԂ܂B
	 * ݂Ȃꍇ̓TCY0̔zԂ܂B
	 * 唼̃NX̓NX[hɗ񋓎qo^̂ŁA
	 * vf̏ꍇ{@link Class#forName(java.lang.String)}ĂяoāA
	 * UNXǂݏo܂B
	 * @throws NullArgumentException nullꍇB
	 */
	static public UEnum[] getAll(Class<? extends UEnum> clazz) {
	    ArgumentChecker.throwIfNull(clazz);

	    Map<Comparable<?>, UEnum> map = getMapWithLoad(clazz, "UEnum#getAll");  //$NON-NLS-1$
		return (map == null) ? new UEnum[0] : (UEnum[])map.values().toArray(new UEnum[map.size()]);
	}
	
	/**
	 * clazz̗񋓎q̓}bvԂ܂B
	 * 唼̃NX̓NX[hɗ񋓎qo^̂ŁA
	 * vf̏ꍇ{@link Class#forName(java.lang.String)}ĂяoāA
	 * UNXǂݏo܂B
	 * @param clazz
	 * @param owner ĂяoƂ̃\bhłBNX[hɎsɃOɏo܂B
	 * @return
	 */
	static private Map<Comparable<?>, UEnum> getMapWithLoad(Class<? extends UEnum> clazz, String owner) {
	    Map<Comparable<?>, UEnum> map = enumMap_s_.get(clazz);
	    if (map == null) {
	    	try {
				Class.forName(clazz.getName());
				log_s_.debug("Load " + clazz.getName() + " by " + owner);  //$NON-NLS-1$//$NON-NLS-2$
			} catch (ClassNotFoundException e) {
				log_s_.error("Class load failure: " + clazz.getName(), e); //$NON-NLS-1$
			}
	    	map = enumMap_s_.get(clazz);
	    }
	    return map;
	}
	
	
	private final Comparable typeName_;
	private final int hashCode_;

	/**
	 * typeNameŗ񋓌^o^܂B
	 * @throws NullArgumentException typeNamenull̏ꍇB
	 * @throws IllegalArgumentException typeNameɓo^Ăꍇ 
	 */
	protected UEnum(Comparable typeName) {
		super();
	    ArgumentChecker.throwIfNull(typeName);

	    typeName_ = typeName;
		Map<Comparable<?>, UEnum> map = enumMap_s_.get(this.getClass());
		if (map == null) {
			map = new TreeMap<Comparable<?>, UEnum>();
			enumMap_s_.put(this.getClass(), map);

		} else if (map.containsKey(typeName_)) {
			throw new IllegalArgumentException(
					typeName + "[" + this.getClass().getName() + "] has already registered."); //$NON-NLS-1$ //$NON-NLS-2$
		}
		hashCode_ = typeName_.hashCode();
		map.put(typeName_, this);
	}
	
	/** NXŃj[NȌ^Ԃ܂B*/
	public Comparable typeName() {
		return typeName_;
	}
	
	/**
	 * NX + ":" + typeNameԂ܂B
	 * @see java.lang.Object#toString()
	 */
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return Classes.simpleName(this.getClass()) + SEPARATOR + typeName_;
	}

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
	public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if ((obj == null) || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        return typeName_.equals(((UEnum)obj).typeName_);
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
	public int hashCode() {
        return hashCode_;
    }


	/**
 	 * ^Ŕr܂B
	 * @param o
	 * @return
	 */
	public int compareTo(Object o) {
		return typeName_.compareTo(((UEnum)o).typeName_);
	}
    
}
