/*
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.memory;


import java.lang.reflect.Constructor;
import java.util.WeakHashMap;

import org.unitarou.lang.NullArgumentException;

/**
 * NXɑ΂QƃJE^[\NXłB
 * CX^X̓}`XbhɑΉĂ܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class ReferenceCounter {

	/** ŗpJE^[łB*/
	static private final class Counter {
		private int count_;
		private Counter() {count_ = 0;}
		private void increase() {++count_;}
		private void decrease() {--count_;}
		private int count() {return count_;}
	}

	/** QƃJE^[\܂B^[Object, {@link Counter}]łB */
	private final WeakHashMap<Object, Counter> counterMap_;
	
	private final Constructor constructor_;
	
	/**
	 * clazz̓pubNNXŁA
	 * ɃpubNȃRs[RXgN^[ĂKv܂B
	 * @throws NullArgumentException null̏ꍇB
	 * @throws ReferenceCounterException Rs[RXgN^ȂꍇB
	 */
	public ReferenceCounter(Class clazz) {
		super();
		if (clazz == null) {
			throw new NullArgumentException();
		}
		try {
			counterMap_ = new WeakHashMap<Object, Counter>();
			constructor_ = clazz.getConstructor(new Class[] {clazz});

		} catch (Exception e) {
			throw new ReferenceCounterException(e);
		}
	}

	/**
	 * instance ̎QƃJEg܂B
	 * instance܂o^̏ꍇ̓JE^[쐬܂B
	 */
	public void increment(Object instance) {
		checkParameter(instance);
		Counter counter;
		synchronized(counterMap_) {
			counter = counterMap_.get(instance);
			if (counter == null) {
				counter = new Counter();
				counterMap_.put(instance, counter);
			}
		}
		counter.increase(); 
	}

	/**
	 * instance̎QƃJEg܂B
	 * QƂPȂꍇ́ÃCX^X̃JE^[폜܂A
	 * 
	 * @throws IllegalArgumentException 
	 *          instanceɕRÂ{@link Counter}݂ȂꍇNXقȂꍇ
	 * @throws NullArgumentException null̏ꍇ 
	 */
	public void decrement(Object instance) {
		checkParameter(instance);
		Counter counter;
		synchronized(counterMap_) {
			counter = counterMap_.get(instance);
			if (counter == null) {
				throw new IllegalArgumentException();			
			}
			if (counter.count() == 1) {
				counterMap_.remove(instance);
			} else {
				counter.decrease(); 
			}
		}
	}
	
	/**
	 * instance̕ҏW\ȃRs[Ԃ܂B<br>
	 * <b>ӁI</b>
	 * ̃\bhĂяoƂ́AinstancegȂłB
	 * ̂悤ȃR[hƂ߂܂B<br>
	 * <code>instance = referenceCounter.getEditable(instance);</code><br>
	 * ̓Iɂ̓JE^[̒l炵A
	 * VCX^XRs[RXgN^ŐA
	 * ̃CX^XԂ܂B
	 * 
	 * @throws ReferenceCounterException Rs[RXgN^̐ɎsꍇB
	 * @throws IllegalArgumentException instanceo^̏ꍇ
	 * @throws NullArgumentException null̏ꍇ
	 */
	public Object getEditable(Object instance) {
		decrement(instance);
		Object ret = null;
		try {
			ret = constructor_.newInstance(new Object[] {instance});
			increment(ret); 
			
		} catch (Exception ignore) { // ȉ͌ČĂяoȂR[h
		    assert false : "Never reach this Statement."; //$NON-NLS-1$
		}
		return ret;
				
	}
	
	/**
	 * instance̎QƃJEgԂ܂B
	 * @throws IllegalArgumentException instanceo^̏ꍇ
	 * @throws NullArgumentException null̏ꍇ
	 */
	public int count(Object instance) {
	    checkParameter(instance);
	    Counter counter = counterMap_.get(instance);
	    return (counter == null) ? 0 : counter.count_;
	}
	
	/**
	 * ̃CX^XŌvĂIuWFNg̐Ԃ܂B
	 * {@link ReferenceCounter}͓{@link WeakHashMap}
	 * gĂA OɎQƂ̂ȂIuWFNg̃JE^[GC̓xɔj܂B
	 */
	public int size() {
	    return counterMap_.size();
	}
	
	private void checkParameter(Object instance) {
		if (instance == null) {
			throw new NullArgumentException();			
		} else if (!constructor_.getDeclaringClass().equals(instance.getClass())) {
			throw new IllegalArgumentException(instance + "is not an instance of " + constructor_.getDeclaringClass()); //$NON-NLS-1$
		} 
	}
}
