/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.ml;

import org.unitarou.util.ArgumentChecker;


/**
 * {@link org.unitarou.ml.NamedEnumByMessages}TuNX̃pbP[Wzɂ
 * messages.propertiesɃANZX̂ɑ΂āA
 * ̃NX̓RXgN^{@link #MessageResource(Class, String)}Ŏw肳ꂽ
 * NX̃pbP[Wzɂmessages.propertiesɃANZX܂B<br>
 * ̃NX{@link org.unitarou.ml.Messages}peLXg\[XǗ
 * ȕւɂ邽߂ɊJ܂B
 * 
 * ̂Q̃\bh͓ɂȂ܂B
 * <pre>
 * String MSG_KEY = Messages.createKey(Class.class, "key");
 * Messages.createByPackage(Class.class).get("key")
 * 
 * MessageResource MSG = new MessageResource(Class.class, "key");
 * MSG.get();
 * </pre>
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class MessageResource {
    
    private final Messages messages_;
    private final String key_;

    /**
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public MessageResource(Class clazz, String key) {
        super();
        ArgumentChecker.throwIfNull(clazz, key);
        
        messages_ = Messages.createByPackage(clazz);
        key_ = Messages.createKey(clazz, key);
    }
    
    /**
     * {@link Messages}̃NXXR[vŃj[NȂ̃CX^X̃L[Ԃ܂B<br>
     * RXgN^Ŏw肵lFQDN̂łB
     * @return
     */
    public String getKey() {
    	return key_;
    }
    
	/**
	 * RXgN^keyɑΉԂ܂B
	 * ȂeLXg̎̂́ARXgN^Ŏw肵
	 * ClassCX^XpbP[Wzɂ
	 * messages.propertiest@C
	 * ClassCX^X̃NX(pbP[W){'.'+key=c
	 * ̌`Ŋi[Ă܂B
	 */
    final public String get() {
        return messages_.get(key_);
    }
    
    /**
	 * RXgN^keyɑΉԂ܂B
	 * ȂeLXg̎̂́ARXgN^Ŏw肵
	 * ClassCX^XpbP[Wzɂ
	 * messages.propertiest@C
	 * ClassCX^X̃NX(pbP[W){'.'+key=c
	 * ̌`Ŋi[Ă܂B
	 * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    final public String get(Object parameter) {
        ArgumentChecker.throwIfNull(parameter);
        return messages_.get(key_, parameter);
    }

    /**
	 * RXgN^keyɑΉԂ܂B
	 * ȂeLXg̎̂́ARXgN^Ŏw肵
	 * ClassCX^XpbP[Wzɂ
	 * messages.propertiest@C
	 * ClassCX^X̃NX(pbP[W){'.'+key=c
	 * ̌`Ŋi[Ă܂B
	 * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    final public String get(Object... parameters) {
        ArgumentChecker.throwIfNull(parameters);
        return messages_.get(key_, parameters);
    }
}
