/*
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.ml;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.lang.Classes;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.WeakedList;



/**
 * ΉړIƂbZ[WnhłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class Messages {
    /**
     * {@link Messages#makeResoureBundle()}
     * {@link MissingResourceException}oꂽƂɁA
     * 㗝ŎgpohłB
     */
    static private class PseudoResourceBundle extends ResourceBundle {
        /** 
         * KnullԂ܂B
         * @see java.util.ResourceBundle#handleGetObject(java.lang.String)
         */
        @Override
		protected Object handleGetObject(String key) {
            return null;
        }

        /** 
         * KvfOEnumerationԂ܂B
         * @see java.util.ResourceBundle#getKeys()
         */
        @Override
        public Enumeration<String> getKeys() {
            return new Vector<String>().elements();
        }
    }
    
    
    /** ̃NX̃VXeK[ł */
	static private final Log logger_s_;

	/**
	 * ftHg̃bZ[WvpeBw肵܂B
	 * t@ĆAMESSAGES_NAME + ".properties" ɂȂ܂B 
	 */
	static private final String MESSAGES_NAME = "messages"; //$NON-NLS-1$

	/**
	 * ^[String:baseName, {@link Messages}]łB
	 * baseName̓pbP[W { "." + MESSAGES_NAMEɂȂ܂B
	 */
	static private final Map<String, Messages> messageMap_s_;
	
	/** 
	 * ݂̃P[łB
	 * MessagesNX͑ŜłЂƂ̃P[܂
	 */
	static private Locale currentLocale_s_;

	/**
	 * ^[{@link MessagesListener}]łB
	 */
	static private final WeakedList<MessagesListener> listeners_s_;	
	
	static {
	    logger_s_ = LogFactory.getLog(Messages.class);
		messageMap_s_ = new TreeMap<String, Messages>();
		currentLocale_s_ = Locale.getDefault();
		listeners_s_ = new WeakedList<MessagesListener>();
	}
		
	/**
	 * clazzPackag1ŋʂMessagesCX^XA
	 * clazzClassLoader(݂Ȃ)ĕԂ܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	static public Messages createByPackage(Class clazz) {
	    ArgumentChecker.throwIfNull(clazz);

	    return createByPackage(clazz, MESSAGES_NAME, clazz.getClassLoader());
	}
	
	/**
	 * clazzPackag1ŋʂMessagesCX^X
	 * w肵classLoader(݂Ȃ)쐬ĕԂ܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException ̉ꂩnull̏ꍇ
	 */
	static public Messages createByPackage(Class clazz, ClassLoader classLoader) {
	    ArgumentChecker.throwIfNull(clazz, classLoader);

		return createByPackage(clazz, MESSAGES_NAME, classLoader);
	}

	/**
	 * clazzPackag1ŋʂMessagesCX^XA
	 * clazzClassLoader(݂Ȃ)ĕԂ܂B
	 * QƂt@CfileName.propertiesɂȂ܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	static public Messages createByPackage(Class clazz, String fileName) {
	    ArgumentChecker.throwIfNull(clazz, fileName);

	    return createByPackage(clazz, fileName, clazz.getClassLoader());
	}

	/**
	 * clazzPackag1ŋʂMessagesCX^X
	 * w肵classLoader(݂Ȃ)쐬ĕԂ܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException ̉ꂩnull̏ꍇ
	 */
	static public Messages createByPackage(
	        Class clazz, String fileName, ClassLoader classLoader) 
	{
	    ArgumentChecker.throwIfNull(clazz, fileName, classLoader);

		StringBuilder stringBuffer = new StringBuilder();
		stringBuffer.append(Classes.packageName(clazz))
					.append('.')
					.append(fileName);
		String baseName = stringBuffer.toString();

		Messages messages = messageMap_s_.get(baseName);
		if (messages == null) {
			messages = new Messages(baseName, classLoader);
		}
		return messages;
	}
	
	/**
	 * bZ[WpKey쐬\bhłB
	 * clazzɎ̃NXƁAKeyɂ̃NXŃj[NȃL[w肵܂B
	 * ߂l Classes.simpleName(clazz) + '.' + key łB
	 * key󕶎̏ꍇ͖̃sIh菜܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException ̉ꂩnull̏ꍇ
	 */
	static public String createKey(Class clazz, String key) {
	    ArgumentChecker.throwIfNull(clazz, key);
	    String simpleName = Classes.simpleName(clazz);
	    StringBuilder sb = new StringBuilder(simpleName.length() + key.length() + 1);
	    sb.append(simpleName);
	    if (key.length() != 0) {
	    	sb.append('.').append(key);
	    }
	    return sb.toString();
	}

	/**
	 * listenerQƂŕێ܂B
	 * Messagesł͎QƂŕێ̂ŁA
	 * Ăяoł͋QƂŕێKv܂B
	 * listernernull̏ꍇ͉܂B
	 */
	static public void addMessagesListener(MessagesListener listener) {
		if (listener == null) {
			return;
		}
		listeners_s_.add(listener);	
	}
	
	/**
	 * o^Ălistener폜܂B
	 * listener݂ȂꍇAnull̏ꍇO͑o܂B
	 */
	static public void removeMessagesListener(MessagesListener listener) {
		listeners_s_.remove(listener);		
	}
	
	/**
	 * P[localeɕύX܂B<br>
	 * ȂAȑOlocaleƓꍇɂ̓Cxg͔܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException localenull̏ꍇB
	 */
	static public void changeLocale(Locale locale) {
	    ArgumentChecker.throwIfNull(locale);

	    if (locale.equals(currentLocale_s_)) {
			return;
		}
		
		currentLocale_s_ = locale;
		// ebZ[WCX^X̍č\z
		for (Iterator ip = messageMap_s_.values().iterator(); ip.hasNext(); ) {
		    ((Messages)ip.next()).makeResoureBundle();
		}
		
		// P[ύXCxg̒ʒm
		MessagesEvent event = new MessagesEvent(Messages.class, currentLocale_s_);		
		for (MessagesListener messagesListener : listeners_s_) {
			messagesListener.changeLocale(event);
		}
	}
	
	/**
	 * <b>K[fobN[h̏ꍇ̂ݗLłB</b>
     * {@link #get(String)}Ȃǂňx
     * ĂяoȂL[𒲂ׂČxxŃOo܂B
     * vpeBt@C̒ɗ]ȃL[`FbN邽߂̋@\łB
	 */
	static public void inspectUnusedMessages() {
        if (!logger_s_.isDebugEnabled()) {
            return;
        }
        for (Iterator ip = messageMap_s_.values().iterator(); ip.hasNext();) {
            Messages messages = (Messages)ip.next();
            for (Enumeration jp = messages.resourceBundle_.getKeys(); jp.hasMoreElements(); ) {
    	        String key = (String)jp.nextElement();
    	        if (!messages.usedKeySet_.contains(key)) {
    	            logger_s_.debug(key + " (bundleName: " + messages.bundleName_ + ")is not used."); //$NON-NLS-1$ //$NON-NLS-2$
    	        }
    	    }
            
        }
	}


	private ResourceBundle resourceBundle_;
	private final String bundleName_;
	private final ClassLoader classLoader_;
	
	/**
	 * {@link #get(String)}ȂǂŌĂяoꂽkey̏Wێ܂B
	 * ̃tB[h̖ړI̓fobNpŁA
	 * {@link #logger_s_}fobN[ĥƂɁA
	 * {@link #finalize()}ňxĂяoȂKey𒲍܂B
	 */
	private final Set<String> usedKeySet_;

	/**
	 * \[XbundleNameƂȂCX^X𐶐܂B
	 * Y郊\[X݂Ȃꍇ́A
	 * ResourceBundlepӂď𑱍s܂B
	 * @throws RuntimeException ResourceBundlepӂłȂꍇB
	 */
	private Messages(String bundleName, ClassLoader classLoader) {
		super();
		resourceBundle_ = null;
		bundleName_ = bundleName;
		classLoader_ = classLoader;
		usedKeySet_ = Collections.synchronizedSet(new HashSet<String>());
		
		makeResoureBundle();
		messageMap_s_.put(bundleName, this);
	}
	
	/**
	 * ResoueceBundle܂B
	 */
	private void makeResoureBundle() {
		try {
			resourceBundle_ 
				= ResourceBundle.getBundle(bundleName_, currentLocale_s_, classLoader_);
			
		} catch (MissingResourceException e) {
		    logger_s_.warn("Can not find resource bundle. Use pseudo object." //$NON-NLS-1$
		            	 + " Bundle name=" + bundleName_ +  //$NON-NLS-1$
		            	 ", Class loader=" + classLoader_ + //$NON-NLS-1$
		            	 ", Current locale=" +  currentLocale_s_); //$NON-NLS-1$
            resourceBundle_ = new PseudoResourceBundle();
		}
	}
	
	/**
	 * key\[XƂēo^ĂtrueԂ܂B
	 * @param key
	 * @return
	 * @throws org.unitarou.lang.NullArgumentException  <code>null</code>̏ꍇ
	 */
	public boolean contains(String key) {
		ArgumentChecker.throwIfNull(key);
		try {
			resourceBundle_.getString(key);
			return true;
			
		} catch (MissingResourceException e) {
			return false;
		}
	}
	/**
	 * keyL[ƂđΉlԂ܂B<br>
	 * .propertiest@Cł́Akey=(߂l)̌`Ŋi[Ă܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇB 
	 */
	public String get(String key) {
	    ArgumentChecker.throwIfNull(key);

		return getString(key);
	}
	
	/**
	 * keyL[ƂđΉlԂ܂B
	 * Ƀp[^ꍇparametersŒu܂B<br>
	 * ũ[́AMessagesFormatɏ܂B
	 * .propertiest@Cł́Akey=(߂l)̌`Ŋi[Ă܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇB 
	 */
	public String get(String key, Object[] parameters) {
	    ArgumentChecker.throwIfNull(key, parameters);

		return MessageFormat.format(getString(key), parameters);
	}
	
	/**
	 * keyL[ƂđΉlԂ܂B
	 * ̃p[^{0}parameterŒu܂B<br>
	 * ũ[́AMessagesFormatɏ܂B
	 * .propertiest@Cł́Akey=(߂l)̌`Ŋi[Ă܂B<br>
	 * 
	 * ̃\bh{@link #get(String, Object[])}̊ȈՃ\bhłB
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇB 
	 */
	public String get(String key, Object parameter) {
	    return get(key, new Object[]{parameter});
	}

	/**
	 * ۂbundleString擾郁\bhłB
	 * [̋󔒂͎菜܂B
	 * 擾Ɏsꍇ̓OɌxxŏ݂܂B
	 */
	private String getString(String key) {
		String ret;
		try {
			ret = resourceBundle_.getString(key);
			if (logger_s_.isDebugEnabled()) {
				usedKeySet_.add(key);
			}
			
		} catch (MissingResourceException e) {
			logger_s_.warn("Cannot find the key = " + key); //$NON-NLS-1$
		    logger_s_.debug("Plz find a lost key from:", e); //$NON-NLS-1$
			ret = "!" + key + "!";  //$NON-NLS-1$//$NON-NLS-2$
		}
		return ret.trim();
	}
	
	/**
	 * ̃CX^XێĂSL[ƑΉ镶
	 * PropertiesƂĕԂ܂B
	 */
	public Properties getAll() {
	    Properties properties = new Properties();
	    for (Enumeration ip = resourceBundle_.getKeys(); ip.hasMoreElements(); ) {
	        String key = (String)ip.nextElement();
	        properties.setProperty(key, getString(key));
	    }
	    return properties;
	}	
}
