/* MessagesEvent.java
 *
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.ml;

import java.util.EventObject;
import java.util.Locale;

import org.unitarou.lang.NullArgumentException;

/**
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class MessagesEvent extends EventObject {
	/**
	 * 
	 */
	private static final long serialVersionUID = 7258489538395171398L;
	
	/**
	 * 
	 */
	private final Locale locale_;

	/**
	 * @param src
	 * @throws NullArgumentException localenull̏ꍇB
	 * @throws IllegalArgumentException sourcenull̏ꍇB
	 */
	public MessagesEvent(Object src, Locale locale) {
		super(src);
		if (locale == null) {
			throw new NullArgumentException();
		}
		locale_ = locale;
	}
	
	/** 
	 * ύX̃P[Ԃ܂B
	 */
	public Locale getLocale() {
		return locale_;
	}
}
