/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.ml;

import org.unitarou.lang.NamedEnum;
import org.unitarou.lang.UEnum;

/**
 * {@link org.unitarou.ml.Messages}g{@link #displayName()}
 * {@link org.unitarou.lang.NamedEnum}łB
 * eTuNX̑pbP[Wɑ݂"messages.properties"
 * uNXv+g.h+ {@link UEnum#typeName()}L[ɂāA
 * O܂B 
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
abstract public class NamedEnumByMessages extends NamedEnum {

    /**
     * @param typeName
     */
    public NamedEnumByMessages(Comparable typeName) {
        super(typeName);
    }

    /**
     * eTuNX̑pbP[Wɑ݂"messages.properties"
     * uNXv+g.h+ {@link UEnum#typeName()}L[ɂāA
     * O܂B
     * 
     * @see org.unitarou.lang.NamedEnum#displayName()
     */
    @Override
	public String displayName() {
        Messages messages = Messages.createByPackage(this.getClass());
        return messages.get(Messages.createKey(this.getClass(), typeName().toString()));
    }
}
