/* CardinalityType.java
 * 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;

import org.unitarou.lang.NullArgumentException;
import org.unitarou.lang.UEnum;

/**
 * Value̔Zx\萔NXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
final public class CardinalityType extends UEnum {
    
    /** Value̐ŁAɕʂ̍\ȂƂ\^łB */
    static public final CardinalityType SINGLE = new CardinalityType("single"); //$NON-NLS-1$
    

    /** Pȏ̒l^Ӗ܂B*/
    static public final CardinalityType LIST = new CardinalityType("list"); //$NON-NLS-1$


    /** NONE܂ނPȏ̒l^Ӗ܂B*/
    static public final CardinalityType ELIST = new CardinalityType("elist"); //$NON-NLS-1$


	/**
	 * Ȃꍇ͗O𑗏o܂B
	 * 
	 * @throws NullArgumentException null̏ꍇ
	 * @throws IllegalArgumentException idɑΉ^݂ȂꍇB
	 */
    static public CardinalityType get(String id) {
	    if (id == null) {
	        throw new NullArgumentException();
	    }
	    CardinalityType ret = (CardinalityType)find(CardinalityType.class, id);
	    if (ret == null) {
	        throw new IllegalArgumentException(id + " not found."); //$NON-NLS-1$
	    }
	    return ret;
    }

    /**
     * @param typeName
     */
    private CardinalityType(String typeName) {
        super(typeName);
    }
}
