/*
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;

import java.io.File;
import java.util.LinkedList;
import java.util.ListIterator;

import org.unitarou.io.FileSnapshot;
import org.unitarou.sgf.parser.SgfParserLogger;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.WeakedList;

/**
 * SGFtH[}bgɂCollection\NXłB
 * Ɉȏ{@link org.unitarou.sgf.RootGameTree}ێ܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class Collection implements Iterable<RootGameTree> {
	
	/**
	 * {@link Collection#iterator()}ŕԂiteratorłB<br>
	 * ̃Ce[^{@link #remove()}T|[g܂B
	 * K{@link UnsupportedOperationException}𑗏o܂B
	 */
	static public class Iterator implements java.util.Iterator<RootGameTree> {
		private final ListIterator<RootGameTree> iterator_;
		
		/**
		 * @param list
		 */
		private Iterator(Collection collection) {
			super();
			iterator_ = collection.rootGameTrees_.listIterator();
		}
		
		/* (non-Javadoc)
		 * @see java.util.Iterator#hasNext()
		 */
		public boolean hasNext() {
			return iterator_.hasNext();
		}
		
		/* (non-Javadoc)
		 * @see java.util.Iterator#next()
		 */
		public RootGameTree next() {
			return iterator_.next();
		}

		/**
		 * @throws UnsupportedOperationException Ko܂B
		 * @see java.util.Iterator#remove()
		 */
		public void remove() {
			throw new UnsupportedOperationException();
		}
	}
	
	/**
	 * CxgXi[i[܂B
	 */
	private final WeakedList<CollectionListener> listeners_;
	
	/** 
	 * [Jt@CɕRÂt@CłB
	 *  d݂hߓŎgp܂B
	 * VKNbv{[hŕRÂȂꍇnullɂȂ܂B
	 */
	private FileSnapshot fileSnapshot_;
	
	/** p[Xۂ̃G[OłB
	 * VKɍ쐬ꍇɂnullɂȂ܂B*/
	private SgfParserLogger parserLog_;
	
	
	/** ^[RootGameTree]łB*/
	private final LinkedList<RootGameTree> rootGameTrees_;

	/**
	 * 
	 */
	public Collection() {
		super();
		listeners_ = new WeakedList<CollectionListener>();
		fileSnapshot_ = null;
		parserLog_ = null;
		rootGameTrees_ = new LinkedList<RootGameTree>();
	}
	
	
	/**
	 * Rs[RXgN^łB
	 * @param src
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇB
	 */
	public Collection(Collection src) {
		super();
		fileSnapshot_ = src.fileSnapshot_;
		listeners_ = new WeakedList<CollectionListener>();
		listeners_.addAll(src.listeners_);
		if (src.parserLog_ != null) {
			parserLog_ = new SgfParserLogger(src.parserLog_);
		} else {
			parserLog_ = null;
		}
		rootGameTrees_ = new LinkedList<RootGameTree>();
		for (RootGameTree rgt : src.rootGameTrees_) {
			rootGameTrees_.add(new RootGameTree(rgt));
		}
	}

	/**
	 * ̃CX^XĎ郊Xi[(OŋQƂK{)ǉ܂B<br>
	 * <b>ӁI</b>̃NXł̓Xi[͓ŎQƂĂ̂ŁA
	 * Oł͋QƂĂKv܂B
	 * 
	 * @param listener o^郊Xi[BOŋQƂĂKvBnull̏ꍇ͉ȂB
	 */
	public void addListener(CollectionListener listener) {
		if (listener == null) {
			return;
		}
		listeners_.add(listener);
	}
	
	/**
	 * o^Ălistener폜܂B
	 * listener݂ȂꍇAnull̏ꍇO͑o܂B
	 * 
	 * @param listener 폜郊Xi[
	 */
	public void removeListener(CollectionListener listener) { 
		listeners_.remove(listener);
	}

	/**
	 * RootGameTreeCollection̍Ōɒǉ܂B
	 * @param rootGameTree ǉ{@link RootGameTree}B
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇB
	 */
	public void addLast(RootGameTree rootGameTree) {
		ArgumentChecker.throwIfNull(rootGameTree);
		rootGameTrees_.addLast(rootGameTree);
	}

	/**
	 * rootGameTreeCollection폜łtrueԂ܂B
	 * @param rootGameTree 폜{@link RootGameTree}B
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public boolean remove(RootGameTree rootGameTree) {
		ArgumentChecker.throwIfNull(rootGameTree);
		if (!rootGameTrees_.remove(rootGameTree)) {
			return false;
		}
		
		// 폜ɐꍇACxgʒmB
		CollectionEvent event = new CollectionEvent(this, this, rootGameTree); 
		for (CollectionListener listener : listeners_) {
			listener.rootGameTreeRemoved(event);
		}
		return true;
	}
	
	
	/**
	 * @param file <code>null</code>܂B
	 */
	public void setFile(File file) {
		if (file == null) {
			fileSnapshot_ = null;
		} else {
			fileSnapshot_ = new FileSnapshot(file);
		}
	}

	public void setParserLog(SgfParserLogger log) {
		parserLog_ = log;
	}

	/**
	 * @param index
	 * @return
	 */
	public RootGameTree get(int index) {
		return rootGameTrees_.get(index);
	}

	/**
	 * RootGameTree̐Ԃ܂B
	 * @return
	 */
	public int size() {
		return rootGameTrees_.size();
	}
	
	/** 
	 * [Jt@CɕRÂt@CԂ܂B
	 * VKNbv{[hŕRÂȂꍇnullɂȂ܂B
	 */
	public File getFile() {
		return (fileSnapshot_ != null) ? fileSnapshot_.file() : null;
	}

	/**
	 * {@link #setFile(File)}ĂяoꂽiKł̃XibvVbgԂ܂B
	 * VKNbv{[hŕRÂȂꍇnullɂȂ܂B
	 * 
	 * @return
	 */
	public FileSnapshot getFileSnapshot() {
		return fileSnapshot_;
	}
	
	public SgfParserLogger getParserLog() {
		return parserLog_;
	}

	/* (non-Javadoc)
	 * @see java.lang.Iterable#iterator()
	 */
	public Iterator iterator() {
		return new Iterator(this);
	}
}
