/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;

import java.util.EventObject;

import org.unitarou.util.ArgumentChecker;

/**
 * {@link org.unitarou.sgf.Collection}̃CxgIuWFNgłB
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class CollectionEvent extends EventObject {

	private static final long serialVersionUID = 4016029252283714116L;

	/**
	 * Cxg{@link Collection}łB
	 * <code>null</code>ɂ͂Ȃ܂B
	 */
	private final Collection collection_;
	
	/**
	 * Cxg{@link RootGameTree}łB
	 * Cxg̎ނɂĂnullԂƂ܂B
	 */
	private final RootGameTree rootGameTree_;
	
	/**
	 * Cxg{@link Node}łB
	 * Cxg̎ނɂĂnullԂƂ܂B
	 */
	private final Node node_;

	/**
	 * Cxg{@link Property}łB
	 * Cxg̎ނɂĂnullԂƂ܂B
	 */
	private final Property property_;
	
	
	/**
	 * 
	 * @param src Cxg\[XB<code>null</code>w肷邱Ƃ͂ł܂B
	 * @param collection CxgB<code>null</code>w肷邱Ƃ͂ł܂B
	 * @throws IllegalArgumentException src, collectionnull̏ꍇ
	 */
	public CollectionEvent(Object src, Collection collection) {
		this(src, collection, null, null, null);
	}

	/**
	 * 
	 * @param src Cxg\[XB<code>null</code>w肷邱Ƃ͂ł܂B
	 * @param collection CxgB<code>null</code>w肷邱Ƃ͂ł܂B
	 * @param rootGameTree CxgB<code>null</code>܂B
	 * @throws IllegalArgumentException src, collectionnull̏ꍇ
	 */
	public CollectionEvent(Object src, Collection collection, RootGameTree rootGameTree) {
		this(src, collection, rootGameTree, null, null);
	}

	/**
	 * 
	 * @param src Cxg\[XB<code>null</code>w肷邱Ƃ͂ł܂B
	 * @param collection CxgB<code>null</code>w肷邱Ƃ͂ł܂B
	 * @param rootGameTree CxgB<code>null</code>܂B
	 * @param node CxgB<code>null</code>܂B
	 * @throws IllegalArgumentException src, collectionnull̏ꍇ
	 */
	public CollectionEvent(Object src, Collection collection, RootGameTree rootGameTree, Node node) 
	{
		this(src, collection, rootGameTree, node, null);
	}

	/**
	 * ̃NX̃vCRXgN^łB
	 *  
	 * @param src Cxg\[XB<code>null</code>w肷邱Ƃ͂ł܂B
	 * @param collection CxgB<code>null</code>w肷邱Ƃ͂ł܂B
	 * @param rootGameTree CxgB<code>null</code>܂B
	 * @param node CxgB<code>null</code>܂B
	 * @param property CxgB<code>null</code>܂B
	 * @throws IllegalArgumentException src, collectionnull̏ꍇ
	 */
	public CollectionEvent(
			Object src, Collection collection, RootGameTree rootGameTree, Node node, Property property) 
	{
		super(src);
		ArgumentChecker.throwIfNull(src, collection);
		collection_ = collection;
		rootGameTree_ = rootGameTree;
		node_ = node;
		property_ = property;
	}


	/**
	 * Cxg{@link Collection}Ԃ܂B
	 * @return Cxg{@link Collection}B<code>null</code>ɂ͂ȂȂB
	 */
	public Collection getCollection() {
		return collection_;
	}


	/**
	 * Cxg{@link RootGameTree}Ԃ܂B
	 * @return Cxg{@link RootGameTree}BCxgɂĂ<code>null</code>Ԃ܂B
	 */
	public RootGameTree getRootGameTree() {
		return rootGameTree_;
	}

	/**
	 * Cxg{@link Node}Ԃ܂B
	 * @return xg{@link Node}BCxgɂĂ<code>null</code>Ԃ܂B
	 */
	public Node getNode() {
		return node_;
	}


	/**
	 * Cxg{@link Property}Ԃ܂B
	 * @return xg{@link Property}BCxgɂĂ<code>null</code>Ԃ܂B
	 */
	public Property getProperty() {
		return property_;
	}
}
