/*
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.unitarou.lang.Strings;
import org.unitarou.util.ArgumentChecker;

/**
 * SGFtH[}bgɂGameTree\NXłB
 * ɈSequenceƂOȏGameTreeێ܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class GameTree {
    /**
     * eGameTreełB
     * g[g̏ꍇnullɂȂ܂B
     */
    private GameTree parent_;
    
	private final Sequence sequence_;
	
	/** ^[GameTree] */
	private final List<GameTree> gameTrees_;
	
	
	/**
	 * GameTree|n_̎Ouc(vɂ|̈łB
	 */
	private String openUtr_;
	
	/**
	 * GameTree|I_ȍ~u')c'vɂ|̈łB
	 */
	private String closeUtr_;
	
	
	/**
	 * ̃CX^X̃nbVR[ḧꕔłB<br> 
	 * CX^XύXǗł{@link #openUtr_}A{@link #closeUtr_}
	 * XVꂽ0Zbg܂B
	 */
	private int hashCodePart_;

	/**
	 * 
	 */
	public GameTree() {
		super();
		parent_ = null;
		sequence_ = new Sequence();
		gameTrees_ = new ArrayList<GameTree>(0);//wǕ͖̂0ł悢
		openUtr_ = Strings.EMPTY;
		closeUtr_ = Strings.EMPTY;
		hashCodePart_ = 0;
	}
	
	/**
	 * ̃NX̃Rs[RXgN^łB
	 * @param src
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public GameTree(GameTree src) {
		super();
		ArgumentChecker.throwIfNull(src);
		parent_ = src.parent_; //e̓|C^ƂĎ
		
		// q͑Sĕʂ
		sequence_ = new Sequence(src.sequence_);
		gameTrees_ = new ArrayList<GameTree>(src.gameTrees_.size());
		for (GameTree gameTree : src.gameTrees_) {
			GameTree child = new GameTree(gameTree);
			child.parent_ = this; //eq̃NRs[璣Ȃ
			gameTrees_.add(child);
		}
		openUtr_ = src.openUtr_;
		closeUtr_ = src.closeUtr_;
		hashCodePart_ = src.hashCodePart_;
	}

	public Sequence getSequence() {
		return sequence_;
	}
	
	/**
	 * childg̎qƂēo^܂B
	 * ȂAnode܂܂܂Ȃchildw肵ꍇ́A܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 * @throws IllegalArgumentException ċAsĂꍇB 
	 */
	public void addGameTree(GameTree child) {
		ArgumentChecker.throwIfNull(child);
			
		if (contains(child)) { //ċÃ`FbN
			throw new IllegalArgumentException();
			
		} else if (child.countNodes() == 0) {
		    return;
		}

		// ȑOɕʂ̐eꍇ́ÃNOB
		if (child.parent_ != null) {
			child.parent_.gameTrees_.remove(child);
		}
		gameTrees_.add(child);
		child.parent_ = this;
	}
	
	/**
	 * childg̎q疕܂B
	 * 폜ɐtrueԂ܂B
	 * child̃CX^Xɑ݂ȂꍇA
	 * null̏ꍇfalseԂ܂B 
	 */
	public boolean removeGameTree(GameTree child) {
	    if (gameTrees_.remove(child)) {
			// parentɕRÂĂꍇ̂݃NAB
			// 菇̊֌WŊɕʂParentĂꍇ̓NAȂB
			if (child.parent_ == this) {
				child.parent_ = null;
			}
	        return true;
	    }
	    return false;
	}
	
	/**
	 * ێĂ鎩g̎qGameTreeׂď܂B
	 */
	public void clearGameTree() {
		for (GameTree gameTree : gameTrees_) {
			// parentɕRÂĂꍇ̂݃NAB
			// 菇̊֌WŊɕʂParentĂꍇ̓NAȂB
			if (gameTree.parent_ == this) {
				gameTree.parent_ = null;
			}
		}
		gameTrees_.clear();	
	}
	
	/** g[g̏ꍇnullԂ܂B */
	public GameTree getParent() { 
	    return parent_;
	}
	
	/**
	 * index(OIW)ŎqGameTreeԂ܂B
	 * @throws IndexOutOfBoundsException index͈͊Ȍꍇ
	 */
	public GameTree getChild(int index) {
		GameTree ret = gameTrees_.get(index);
		assert ret.parent_ == this : "Child does not have right parent(this). Child's parent is " + ret.parent_; //$NON-NLS-1$
		return ret;	
	}
	
	/**
	 * qGameTreeԂ܂B<br>
	 * ݂Ȃꍇ͗vfO̔zԂ܂B
	 * @return
	 */
	public GameTree[] getChildren() {
		GameTree[] ret = gameTrees_.toArray(new GameTree[gameTrees_.size()]);
		for (GameTree gameTree : ret) {
			assert gameTree.parent_ == this : "Child does not have right parent(this). Child's parent is " + gameTree.parent_; //$NON-NLS-1$
		}
		return ret;
	}
	
	public int getChildrenSize() {
		return gameTrees_.size();
	}
	
	
	/**
	 * ݕێĂSm[hԂ܂B 
	 */
	public int countNodes() {
		int count = 0;
		Iterator ip = gameTrees_.iterator();
		while(ip.hasNext()) {
			count += ((GameTree)ip.next()).countNodes();
		}
		count += sequence_.size();
		return count;
	}
	
	/**
	 * treẽCX^X̂ǂ(q)ɑ݂ꍇtrueԂ܂B 
	 */
	public boolean contains(GameTree tree) {
		for (GameTree child : gameTrees_) {
			if ((child == tree) || child.contains(tree)) {
				return true;
			}
		}
		return false;
	}

	/** treẽCX^X̎qiȍ~ł͂Ȃj̏ꍇtrueԂ܂B */
	public boolean containsDirectly(GameTree tree) {
		return gameTrees_.contains(tree);	
	}
	
	/**
	 * GameTree|n_̎Ouc(vɂ|̈ݒ肵܂B
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void setOpenUtr(String value) {
		ArgumentChecker.throwIfNull(value);
		openUtr_ = value;
		hashCodePart_ = 0;
	}

	/**
	 * GameTree|I_ȍ~u')c'v|̈ݒ肵܂B
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void setCloseUtr(String value) {
		ArgumentChecker.throwIfNull(value);
		closeUtr_ = value;
		hashCodePart_ = 0;
	}
	
	/**
	 * GameTree|n_̎Ouc(vɂ|̈Ԃ܂B<br>
	 * <code>null</code>͕Ԃ܂B
	 */
	public String getOpenUtr() {
		return openUtr_;
	}

	/**
	 * GameTree|I_ȍ~u')c'v|̈Ԃ܂B<br>
	 * <code>null</code>͕Ԃ܂B
	 */
	public String getCloseUtr() {
		return closeUtr_;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		
		if (obj == null || !obj.getClass().equals(getClass())) {
			return false;
		}
		
		GameTree gt = (GameTree)obj;
		
		return (parent_ == gt.parent_)
				&& sequence_.equals(gt.sequence_)
				&& gameTrees_.equals(gt.gameTrees_)
				&& openUtr_.equals(gt.openUtr_)
				&& closeUtr_.equals(gt.closeUtr_);
	}
	
	/*
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		if (hashCodePart_ == 0) {
			hashCodePart_ = openUtr_.hashCode() * 11
							+ closeUtr_.hashCode() * 13;
		}
		return sequence_.hashCode() 
				+ gameTrees_.size() * 77
				+ hashCodePart_;
	}
}
