/*
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;

import java.util.Iterator;
import java.util.LinkedHashMap;

import org.unitarou.lang.Strings;
import org.unitarou.util.ArgumentChecker;

/**
 * SGFtH[}bgɂProperty\NXłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public final class Property {
	
	/** t@Cɑ݂啶܂ID nullɂ͌ĂȂ܂B*/
	private String entireId_;
	
	/** 
	 * ݂IDɑ΂^łBnullɂ͌ĂȂ܂ 
	 */
	private SgfId sgfId_;
	
    /**
	 * ^[String:{@link Value#getString()}, Value]łB
	 * {@link ValueType}{@link CardinalityType#ELIST}A
	 * {@link CardinalityType#LIST}ȊȌꍇɂ
	 * vf͕KPɂȂ܂B
	 */
	private final LinkedHashMap<String, Value> valueMap_;

	/**
	 * Property|̈̑Oɂ|̈łB
	 */
	private String openUtr_;
	
	/**
	 * Property|̈̌ɂ|̈łB
	 */
	private String closeUtr_;
	
	/**
	 * ̃CX^X̃nbVR[hłB<br> 
	 * CX^XύXǗł
	 * {@link #sgfId_}A{@link #openUtr_}A{@link #closeUtr_}A
	 * {@link #valueMap_}
	 * XVꂽ0Zbg܂B
	 */
	private int hashCode_;

	/**
	 * ID, ValueAUTRƂɋ󕶎̃CX^X쐬܂B
	 */
	public Property() {
		super();
		entireId_ = Strings.EMPTY;
		sgfId_ = SgfId.find(Strings.EMPTY);
		valueMap_ = new LinkedHashMap<String, Value>(1); //̂P
		openUtr_ = Strings.EMPTY;
		closeUtr_ = Strings.EMPTY;
		hashCode_ = 0;
	}
	
	/**
	 * ̃NX̃Rs[RXgN^łB
	 * @throws org.unitarou.lang.NullArgumentException srcnull̏ꍇ
	 */
	public Property(Property src) {
	    ArgumentChecker.throwIfNull(src);

		entireId_ = src.entireId_;
		sgfId_ = src.sgfId_;  //Sgfs.TypeImmutableȂ̂ŁAshallow copył悢B

		valueMap_ = new LinkedHashMap<String, Value>(src.valueMap_);
		openUtr_ = src.openUtr_;
		closeUtr_ = src.closeUtr_;
		hashCode_ = src.hashCode_;
	}
	
	
	/**
	 * w肳ꂽtypestringŏ܂B<br>
	 * <b></b>string{@link Sgfs#escapeForStore(String)}Ȃǂ
	 * GXP[v<b>Ȃ</b>BōďŝŁA
	 * f[^Ԉĕێ悤ɂȂ܂B
	 * @param sgfId
	 * @param string
	 * @throws NullPointerException ̂ǂ炩ł<code>null</code>̏ꍇ
	 */
	public Property(SgfId sgfId, String string) {
	    ArgumentChecker.throwIfNull(sgfId, string);

	    entireId_ = sgfId.id();
		sgfId_ = sgfId;
		valueMap_ = new LinkedHashMap<String, Value>(1);
		openUtr_ = Strings.EMPTY;
		closeUtr_ = Strings.EMPTY;
		hashCode_ = 0;

		if (ValueType.permitsMultiValues(sgfId_.cardinalityType())) {
			addValue(new Value(string));
		} else {
			setValue(new Value(string));
		}
	}

	/**
	 * w肳ꂽentireIdvalueŏ܂B<br>
	 * 
	 * @throws NullPointerException ̂ǂ炩ł<code>null</code>̏ꍇ
	 * @throws IllegalArgumentException entireId_SGFIDƂċełȂꍇA
	 *          idlȂ̂ɋ󕶎ȊOw肵ꍇB
	 */
	public Property(String entireId, String string) {
	    ArgumentChecker.throwIfNull(entireId, string);
			
		if (!Sgfs.isValidEntireId(entireId)) {
			throw new IllegalArgumentException("Invalid entireId = " + entireId); //$NON-NLS-1$
		} 
		
		entireId_ = entireId;
		sgfId_ = SgfId.find(entireId);
		valueMap_ = new LinkedHashMap<String, Value>(1);
		openUtr_ = Strings.EMPTY;
		closeUtr_ = Strings.EMPTY;
		hashCode_ = 0;
		if (ValueType.permitsMultiValues(sgfId_.cardinalityType())) {
			addValue(new Value(string));
		} else {
			setValue(new Value(string));
		}
	}


	/**
	 * idݒ肵܂B<br>
	 * {@link #entireId_}{@link #sgfId_}ɍXV܂(idɓȂ)B
	 * @param id
	 * @throws IllegalArgumentException {@link Sgfs#isValidId(String)}==falsȅꍇB
	 */
	public void setId(String id) {
		if (!Sgfs.isValidId(id)) {
		    throw new IllegalArgumentException("Bad id = " + id); //$NON-NLS-1$
		}
		entireId_ = id;
		sgfId_ = SgfId.find(id);
		hashCode_ = 0;
		singularizeIfNeeds();
	}
	
	/**
	 * entireIdݒ肵܂BidtypeɍXV܂B
	 * @param entireId
	 * @throws IllegalArgumentException {@link Sgfs#isValidEntireId(String)}==falsȅꍇB
	 */
	public void setEntireId(String entireId) {
		if (!Sgfs.isValidEntireId(entireId)) {
		    throw new IllegalArgumentException(
		            "Bad entireId='" + entireId + "'"); //$NON-NLS-1$ //$NON-NLS-2$
		}
		
		entireId_ = entireId;
		sgfId_ = SgfId.find(entireId);
		hashCode_ = 0;
		singularizeIfNeeds();
	}
	
	
	
	/** ftHgRXgN^ŏ̏Ԃɖ߂܂B*/
	public void clear() {
		entireId_ = Strings.EMPTY;
		sgfId_ = SgfId.find(Strings.EMPTY);
		valueMap_.clear();
		openUtr_ = Strings.EMPTY;
		closeUtr_ = Strings.EMPTY;
		hashCode_ = 0;
	}
	
    /**
	 * valueݒ肵܂BȑO̒lu܂B
	 * ̃\bh݂͌̃vpeB̌^Plꍇ̂݌ĂяoƂł܂B
	 * AB[...][...]ȂǁAlvpeBŌĂяoꍇ
	 * IllegalStateExceptiono܂B
	 * 
	 * @param value
	 * @throws NullPointerException value<code>null</code>̏ꍇ
	 * @throws IllegalStateException ݂̌^lꍇ
	 */
	public void setValue(Value value) {
	    checkValue(value, false);
	    valueMap_.clear();
	    valueMap_.put(value.getString(), value);
	    hashCode_ = 0;
	}

	/**
	 * valuesǉ܂BzɃCX^XƓlɂꍇ͖܂B<br>
	 * values̊evf͕ʂĒǉ܂B]āAǉɊÕCX^X
	 * C邱Ƃ͂ł܂B
	 * 
	 * ̃\bh݂͌̃vpeB̌^lꍇɂ̂݌ĂяoƂł܂B
	 * B[...]ȂǁAPlȂvpeBŌĂяoꍇ
	 * IllegalStateExceptiono܂B
	 * 
	 * ܂{@link CardinalityType#ELIST}̏ꍇAŏEmptyĂꍇ
	 * 폜܂B
	 * 
	 * @param values ǉlA󕶎͋null͕s
	 * @return VKɒǉꂽl̐B
	 * @throws NullPointerException value<code>null</code>̏ꍇ
	 * @throws IllegalStateException ݂̌^lȂꍇ
	 */
	public int addValue(Value[] values) {
	    checkValue(values, true);

	    hashCode_ = 0;
	    //TODO PASS̓Elist`FbNłĂȂB
		if (sgfId_.cardinalityType().equals(CardinalityType.ELIST)
				&& values.length != 0) 
		{
			if (Strings.EMPTY.equals(values[0].getString())) {
				valueMap_.clear();
			    valueMap_.put(values[0].getString(), new Value(values[0]));
				return 1;
			}
			valueMap_.remove(Strings.EMPTY);
		}
		int count = 0;
		for (int i = 0; i < values.length; ++i) {
		    if (valueMap_.containsKey(values[i].getString())) {
		        continue;
		    }
		    valueMap_.put(values[i].getString(), new Value(values[i]));
		    ++count;
		}
		return count;
	}
	
	
	/**
	 * valueǉ܂BzɃCX^XƓlɂꍇ͖܂B<br>
	 * ܂{@link CardinalityType#ELIST}̏ꍇA
	 * ŏEmptyĂꍇ͍폜܂B
	 * ΂Emptyw肵ꍇ͌ݕێĂvfSč폜Ēu܂B
	 * 
	 * @param value ǉlA󕶎͋null͕s
	 * @throws NullPointerException value<code>null</code>̏ꍇ
	 */
	public void addValue(Value value) {
		ArgumentChecker.throwIfNull(value);
		
		hashCode_ = 0;
		if (sgfId_.cardinalityType().equals(CardinalityType.ELIST)) {
			if (Strings.EMPTY.equals(value.getString())) {
				valueMap_.clear();
			}
			valueMap_.remove(Strings.EMPTY);
		}
		valueMap_.put(value.getString(), value);
	}

	/**
	 * value폜܂Bvaluȇ݃`FbNdatum݂̂ōs܂B
	 * ݂Ȃꍇ͕ԂlfalseɂȂ܂B
	 * 
	 * @param value 폜lA󕶎͋null͕s
	 * @return value݂ꍇB
	 * @throws NullPointerException value<code>null</code>̏ꍇ
	 * @throws IllegalStateException ݂̌^lȂꍇ
	 */
	public boolean removeValue(Value value) {
	    checkValue(value, true);
	    hashCode_ = 0;
		return valueMap_.remove(value.getString()) != null; 
	}
	
	/**
	 * typePl̏ꍇ́Avalues_擪݂̂cĎc͍폜܂B
	 */
	public void singularizeIfNeeds() {
		if ((1 < valueMap_.size()) && !ValueType.permitsMultiValues(sgfId_.cardinalityType())) {
		    Value value = valueMap_.values().toArray(new Value[valueMap_.size()])[0];
		    valueMap_.clear();
		    valueMap_.put(value.getString(), value);
		    hashCode_ = 0;
		}
	}

	
	/**
	 * Valuê݃NA[܂B
	 */
	public void clearValue() {
		valueMap_.clear();
		hashCode_ = 0;
	}
	
	/**
	 * Property|Oɂ|̈ݒ肵܂B
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void setOpenUtr(String value) {
		ArgumentChecker.throwIfNull(value);
		openUtr_ = value;
		hashCode_ = 0;
	}

	/**
	 * Property|ɂ|̈ݒ肵܂B
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void setCloseUtr(String value) {
		ArgumentChecker.throwIfNull(value);
		closeUtr_ = value;
		hashCode_ = 0;
	}
	
	
	// getter
	/**
	 * At@xbg啶݂̂ō\鐳IDԂ܂B
	 * nullɂ͌ĂȂ܂B
	 */
	public String getId() {
		return sgfId_.id();
	}
	
	/**
	 * t@Cɑ݂啶܂IDԂ܂B
	 * nullɂ͌ĂȂ܂
	 */
	public String getEntireId() {
		return entireId_;
	}
	
	/**
	 * null͌ĕԂ܂B
	 */
	public SgfId sgfId() {
		return sgfId_;
	}
	
	/**
	 * ݂̃CX^X̓ԂtrueԂ܂B
	 */
	public boolean isValid() {
		return (Sgfs.isValidEntireId(entireId_) 
			&& (ValueType.isVaild(
			        sgfId_.cardinalityType(),
			        getValues())));
	}
	
	

	/**
	 * SGFƂďo`̕Ԃ܂B<br>
	 * ̃XgO̓GXP[vĂ܂BӂĂB
	 * @return
	 */
	public String toSgf() {
		StringBuilder sb = new StringBuilder();
		sb.append(openUtr_);
		sb.append(entireId_);
		
		for (Value value : valueMap_.values()) {
			sb.append(value.getOpenUtr());
			sb.append(Sgfs.VALUE_START_MARK);
			sb.append(Sgfs.escapeForStore(value.getString()));
			sb.append(Sgfs.VALUE_END_MARK);
		}
		sb.append(closeUtr_);
		return sb.toString();
	}
	

	/**
	 * Property|Oɂ|̈Ԃ܂B<br>
	 * <code>null</code>͕Ԃ܂B
	 */
	public String getOpenUtr() {
		return openUtr_;
	}

	/**
	 * Property|ɂ|̈Ԃ܂B<br>
	 * <code>null</code>͕Ԃ܂B
	 */
	public String getCloseUtr() {
		return closeUtr_;
	}
	
	/**
	 * CX^XsgfIdIDstringꍇtrueԂ܂B 
	 * @param sgfId
	 * @param point
	 * @return
	 */
	public boolean contains(SgfId sgfId, String string) {
		ArgumentChecker.throwIfNull(sgfId, string);
		if (!sgfId.equals(sgfId_)) {
			return false;
		}
		return contains(string);
	}
	

	/**
	 * objnullǂƁA
	 * ݂Property̌^[Pl or l]
	 * permitsMultiValuesĂ邩`FbN܂B
	 * 
	 * @throws NullPointerException obj<code>null</code>̏ꍇ
	 * @throws IllegalStateException ݂̌^permitsMultiValuesĂȂꍇ
	 */
	private void checkValue(Object obj, boolean permitsMultiValues) {
		ArgumentChecker.throwIfNull(obj);
		
		if (permitsMultiValues 
		        != ValueType.permitsMultiValues(
		        	        sgfId_.cardinalityType())) {

		    throw new IllegalStateException(
			        "type_.getCardinalityType() is :" //$NON-NLS-1$
			        + sgfId_.cardinalityType()); 
		}
	}
	
	/**
	 * ݂̒lԂ܂B<br>
	 * <b></b>PropertyKPlێƊmMłꍇ̂݁A
	 * ̃\bhĂяoĉB
	 * m({@link Sgfs}Œ`ĂȂ)Propertyɑ΂Ẵ\bhĂяoꍇA
	 * K{@link IllegalArgumentException}o܂B
	 * ̃\bh{@link #getValue()}.{@link Value#getString()}̊ȈՔłłB
	 * 
	 * @throws IllegalStateException ݂̌^lꍇ
	 */
	public String getString() {
		return getValue().getString();
	}
	
	/**
	 * ݂̌^lȂꍇ́Avf̔zԂ܂B
	 * ̃\bh{@link #getValue()}.{@link Value#getString()}̊ȈՔłłB
	 */	
	public String[] getStrings() {
	    String[] ret = new String[valueMap_.size()];
	    int index = 0;
	    for (Iterator ip = valueMap_.values().iterator(); ip.hasNext(); ) {
	        ret[index] = ((Value)ip.next()).getString();
	        ++index;
	    }
		return ret; 
	}
	
	/**
	 * 
	 * @param string
	 * @return
	 */
	public boolean contains(String string) {
		ArgumentChecker.throwIfNull(string);
		return valueMap_.containsKey(string);
	}
	
	/**
	 * ݂̒lԂ܂B<br>
	 * <b></b>PropertyKPlێƊmMłꍇ̂݁A
	 * ̃\bhĂяoĉB
	 * m({@link Sgfs}Œ`ĂȂ)Propertyɑ΂Ẵ\bhĂяoꍇA
	 * K{@link IllegalArgumentException}o܂B<br>
	 * ܂Al͕ʂĕԂ̂ŁAҏWĂf܂B
	 * 
	 * @throws IllegalStateException ݂̌^lꍇ
	 */
	public Value getValue() {
	    checkValue(this, false);
		return new Value(valueMap_.values().iterator().next());
	}

	/**
	 * ݂̌^lȂꍇ́Avf̔zԂ܂B<br>
	 * <b></b>l͕ʂĕԂ̂ŁAҏWĂf܂B
	 */	
	public Value[] getValues() {
		Value[] ret = new Value[valueMap_.size()];
		int index = 0;
		for (Value src : valueMap_.values()) {
			ret[index] = new Value(src);
			++index;
		}
		return ret;
	}
	
	/**
	 * ݂̃CX^XɊi[Ă{@link Value}̐Ԃ܂B
	 */
	public int size() {
	    return valueMap_.size();
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		if ((obj == null) || !obj.getClass().equals(this.getClass())) {
		    return false;
		}
		Property target = (Property)obj;
		return /*entireId_.equals(target.entireId_) && id_.equals(target.id_) 
				&& */sgfId_.equals(target.sgfId_) && valueMap_.equals(target.valueMap_)
				&& openUtr_.equals(openUtr_)
				&& closeUtr_.equals(closeUtr_);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		if (hashCode_ == 0) {
			hashCode_ = /*id_.hashCode() + entireId_.hashCode() * 3 + */  
				sgfId_.hashCode() * 5 
				+ valueMap_.hashCode() * 7
				+ openUtr_.hashCode() * 11
				+ closeUtr_.hashCode() * 13;
		}
		return hashCode_;
	}
	
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append(openUtr_);
		sb.append(entireId_);

		if (valueMap_.isEmpty()) {
            return "<<EMPTY>>"; //$NON-NLS-1$
        }
        for (Value value : valueMap_.values()) {
	        sb.append('[').append(value.getString()).append(']');
        }
		sb.append(closeUtr_);
		return sb.toString();		
	}
}
