/* 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

import org.unitarou.lang.NameDisplayable;
import org.unitarou.lang.UEnum;
import org.unitarou.ml.Messages;

/**
 * Property̌^([gpAQ[pApAetc...)
 * \񋓌^NXłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public enum PropertyType implements NameDisplayable {
	ROOT,
	GAME_INFO ,
	SETUP,
	MOVE,
	INHERIT,
	ANY,
	;

	static private Messages messages_s_ = Messages.createByPackage(PropertyType.class);
	/**
     * ^[{@link PropertyType}, Set[{@link SgfId}]]
     * e{@link PropertyType}ŕނłSvpeB̏WĂ܂B
     */
    static private Map<PropertyType, Set<SgfId>> propertyTypeMap_s_ = null;
    
    /**
     * 
     */
    static private void makeGameInfoSet() {
        UEnum[] enums = UEnum.getAll(SgfId.class);
        propertyTypeMap_s_ = new TreeMap<PropertyType, Set<SgfId>>();
        for (int i = 0; i < enums.length; ++i) {
            SgfId sgfType = (SgfId)enums[i];
            Set<SgfId> typeSet = propertyTypeMap_s_.get(sgfType.propertyType());
            if (typeSet == null) {
                typeSet = new TreeSet<SgfId>();
                propertyTypeMap_s_.put(sgfType.propertyType(), typeSet);
            }
            typeSet.add(sgfType);
        }
    }

    private final String displayNameKey_;
    
	/**
	 * @param name
	 * @param ordinal
	 */
	PropertyType() {
		displayNameKey_ = Messages.createKey(getClass(), name());
	}


	/**
	 * ̃CX^X̃^CvɑSĂ{@link SgfId}WԂ܂B
	 * W͕ύXs\łB
	 * @param propertyType
	 * @return
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public Set<SgfId> getSgfTypeSet() {
	    if (propertyTypeMap_s_ == null) {
	        makeGameInfoSet();
	    }
        Set<SgfId> typeSet =propertyTypeMap_s_.get(this);
        if (typeSet == null) {
            typeSet = new HashSet<SgfId>();
        }	    
        return Collections.unmodifiableSet(typeSet);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.lang.NameDisplayable#displayName()
	 */
	public String displayName() {
		return messages_s_.get(displayNameKey_);
	}
}
