/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;

import java.util.Iterator;
import java.util.LinkedHashMap;

import org.unitarou.lang.NullArgumentException;
import org.unitarou.lang.Strings;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link org.unitarou.sgf.Property}ێ{@link Value}̔z
 * ܂Ƃ߂NXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class PropertyValue {

    /** ̃CX^Xi[ĂvpeBłB*/
    private final Property property_;

    /**
	 * ^[String:{@link Value#getString()}, Value]łB
	 * {@link ValueType}{@link CardinalityType#ELIST}A
	 * {@link CardinalityType#LIST}ȊȌꍇɂ
	 * vf͕KPɂȂ܂B
	 */
	private final LinkedHashMap<String, Value> valueMap_;

	/**
	 * {@link #hashCode()}ŕԂlێ܂B
	 * {@link #setValue(Value)}A{@link #addValue(Value)}A{@link #addValue(Value[])}
	 * {@link #removeValue(Value)}AȂǂŃZbg܂B
	 */
	private int hashCode_;
	
    /**
     * {@link Property}Ăяo邱Ƃ݂̂z肵Ă܂B
     * {@link #valueMap_}̒͋ŏ܂B
     * 
     * @throws NullArgumentException null̏ꍇ 
     */
    PropertyValue(Property property) {
        super();
        ArgumentChecker.throwIfNull(property);
        property_ = property;
        valueMap_ = new LinkedHashMap<String, Value>(1);
        hashCode_ = 0;
    }


    /**
	 * valueݒ肵܂BȑO̒lu܂B
	 * ̃\bh݂͌̃vpeB̌^Plꍇ̂݌ĂяoƂł܂B
	 * AB[...][...]ȂǁAlvpeBŌĂяoꍇ
	 * IllegalStateExceptiono܂B
	 * 
	 * @param value
	 * @throws NullPointerException value<code>null</code>̏ꍇ
	 * @throws IllegalStateException ݂̌^lꍇ
	 */
	public void setValue(Value value) {
	    checkValue(value, false);
	    valueMap_.clear();
	    valueMap_.put(value.getString(), value);
	    hashCode_ = 0;
	}

	/**
	 * valuesǉ܂BzɃCX^XƓlɂꍇ͖܂B<br>
	 * values̊evf͕ʂĒǉ܂B]āAǉɊÕCX^X
	 * C邱Ƃ͂ł܂B
	 * 
	 * ̃\bh݂͌̃vpeB̌^lꍇɂ̂݌ĂяoƂł܂B
	 * B[...]ȂǁAPlȂvpeBŌĂяoꍇ
	 * IllegalStateExceptiono܂B
	 * 
	 * ܂{@link CardinalityType#ELIST}̏ꍇAŏEmptyĂꍇ
	 * 폜܂B
	 * 
	 * @param values ǉlA󕶎͋null͕s
	 * @return VKɒǉꂽl̐B
	 * @throws NullPointerException value<code>null</code>̏ꍇ
	 * @throws IllegalStateException ݂̌^lȂꍇ
	 */
	public int addValue(Value[] values) {
	    checkValue(values, true);

		hashCode_ = 0;
	    //TODO PASS̓Elist`FbNłĂȂB
		if (property_.sgfId().cardinalityType().equals(CardinalityType.ELIST)
				&& values.length != 0) 
		{
			if (Strings.EMPTY.equals(values[0].getString())) {
				valueMap_.clear();
			    valueMap_.put(values[0].getString(), new Value(values[0]));
				return 1;
			}
			valueMap_.remove(Strings.EMPTY);
		}
		int count = 0;
		for (int i = 0; i < values.length; ++i) {
		    if (valueMap_.containsKey(values[i].getString())) {
		        continue;
		    }
		    valueMap_.put(values[i].getString(), new Value(values[i]));
		    ++count;
		}
		return count;
	}
	
	
	/**
	 * valueǉ܂BzɃCX^XƓlɂꍇ͖܂B<br>
	 * ܂{@link CardinalityType#ELIST}̏ꍇA
	 * ŏEmptyĂꍇ͍폜܂B
	 * ΂Emptyw肵ꍇ͌ݕێĂvfSč폜Ēu܂B
	 * 
	 * @param value ǉlA󕶎͋null͕s
	 * @throws NullPointerException value<code>null</code>̏ꍇ
	 */
	public void addValue(Value value) {
		ArgumentChecker.throwIfNull(value);
		
		hashCode_ = 0;
		if (property_.sgfId().cardinalityType().equals(CardinalityType.ELIST)) {
			if (Strings.EMPTY.equals(value.getString())) {
				valueMap_.clear();
			}
			valueMap_.remove(Strings.EMPTY);
		}
		valueMap_.put(value.getString(), value);
	}

	/**
	 * value폜܂Bvaluȇ݃`FbNdatum݂̂ōs܂B
	 * ݂Ȃꍇ͕ԂlfalseɂȂ܂B
	 * 
	 * @param value 폜lA󕶎͋null͕s
	 * @return value݂ꍇB
	 * @throws NullPointerException value<code>null</code>̏ꍇ
	 * @throws IllegalStateException ݂̌^lȂꍇ
	 */
	public boolean removeValue(Value value) {
	    checkValue(value, true);
		hashCode_ = 0;
		return valueMap_.remove(value.getString()) != null; 
	}
	
	/**
	 * typePl̏ꍇ́Avalues_擪݂̂cĎc͍폜܂B
	 */
	public void singularizeIfNeeds() {
		if ((1 < valueMap_.size()) && !ValueType.permitsMultiValues(property_.sgfId().cardinalityType())) {
		    Value value = valueMap_.values().toArray(new Value[valueMap_.size()])[0];
		    valueMap_.clear();
		    valueMap_.put(value.getString(), value);
			hashCode_ = 0;
		}
	}

	/**
	 * ftHgRXgN^ŏ̏Ԃɖ߂܂B
	 */
    public void clear() {
		hashCode_ = 0;
        valueMap_.clear();
    }
	
	/**
	 * objnullǂƁA
	 * ݂Property̌^[Pl or l]
	 * permitsMultiValuesĂ邩`FbN܂B
	 * 
	 * @throws NullPointerException obj<code>null</code>̏ꍇ
	 * @throws IllegalStateException ݂̌^permitsMultiValuesĂȂꍇ
	 */
	private void checkValue(Object obj, boolean permitsMultiValues) {
		ArgumentChecker.throwIfNull(obj);
		
		if (permitsMultiValues 
		        != ValueType.permitsMultiValues(
		        	        property_.sgfId().cardinalityType())) {

		    throw new IllegalStateException(
			        "type_.getCardinalityType() is :" //$NON-NLS-1$
			        + property_.sgfId().cardinalityType()); 
		}
	}
	
	/**
	 * ݂̒lԂ܂B<br>
	 * <b></b>PropertyKPlێƊmMłꍇ̂݁A
	 * ̃\bhĂяoĉB
	 * m({@link Sgfs}Œ`ĂȂ)Propertyɑ΂Ẵ\bhĂяoꍇA
	 * K{@link IllegalArgumentException}o܂B
	 * ̃\bh{@link #getValue()}.{@link Value#getString()}̊ȈՔłłB
	 * 
	 * @throws IllegalStateException ݂̌^lꍇ
	 */
	public String getString() {
		return getValue().getString();
	}
	
	/**
	 * ݂̌^lȂꍇ́Avf̔zԂ܂B
	 * ̃\bh{@link #getValue()}.{@link Value#getString()}̊ȈՔłłB
	 */	
	public String[] getStrings() {
	    String[] ret = new String[valueMap_.size()];
	    int index = 0;
	    for (Iterator ip = valueMap_.values().iterator(); ip.hasNext(); ) {
	        ret[index] = ((Value)ip.next()).getString();
	        ++index;
	    }
		return ret; 
	}
	
	/**
	 * 
	 * @param string
	 * @return
	 */
	public boolean contains(String string) {
		ArgumentChecker.throwIfNull(string);
		return valueMap_.containsKey(string);
	}
	
	/**
	 * ݂̒lԂ܂B<br>
	 * <b></b>PropertyKPlێƊmMłꍇ̂݁A
	 * ̃\bhĂяoĉB
	 * m({@link Sgfs}Œ`ĂȂ)Propertyɑ΂Ẵ\bhĂяoꍇA
	 * K{@link IllegalArgumentException}o܂B<br>
	 * ܂Al͕ʂĕԂ̂ŁAҏWĂf܂B
	 * 
	 * @throws IllegalStateException ݂̌^lꍇ
	 */
	public Value getValue() {
	    checkValue(this, false);
		return new Value(valueMap_.values().iterator().next());
	}

	/**
	 * ݂̌^lȂꍇ́Avf̔zԂ܂B<br>
	 * <b></b>l͕ʂĕԂ̂ŁAҏWĂf܂B
	 */	
	public Value[] getValues() {
		Value[] ret = new Value[valueMap_.size()];
		int index = 0;
		for (Value src : valueMap_.values()) {
			ret[index] = new Value(src);
			++index;
		}
		return ret;
	}
	
	/**
	 * ݂̃CX^XɊi[Ă{@link Value}̐Ԃ܂B
	 */
	public int size() {
	    return valueMap_.size();
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		if ((obj == null) || !obj.getClass().equals(this.getClass())) {
		    return false;
		}
		PropertyValue target = (PropertyValue)obj;
		return valueMap_.equals(target.valueMap_);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		if (hashCode_ == 0) {
			for (Value src : valueMap_.values()) {
				hashCode_ += hashCode_ * src.hashCode();
			}
		}
		return hashCode_;
	}
	
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
	public String toString() {
        if (valueMap_.isEmpty()) {
            return "<<EMPTY>>"; //$NON-NLS-1$
        }
        StringBuilder sb = new StringBuilder();
        for (Value value : valueMap_.values()) {
	        sb.append('[').append(value.getString()).append(']');
        }
        return sb.toString();
    }
}
