/*
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;


import java.nio.charset.Charset;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.type.Application;
import org.unitarou.sgf.type.FileFormat;
import org.unitarou.sgf.type.GameMode;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.sgf.type.SgfNumber;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.Style;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.SgfArgumentChecker;
import org.unitarou.util.ArgumentChecker;



/**
 * Collection̊KwGameTreełB
 * PropertyTypeRootɑf[^߂ĕێ܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class RootGameTree extends GameTree {
	static public RootGameTree newInstance(Application application, SgfSize size) {
	    ArgumentChecker.throwIfNull(application, size);

		RootGameTree ret = new RootGameTree();
		ret.setApplication(application);
		ret.setSize(size);
		return ret;
	}

	/**
	 * CA[]vpeBŎw肳ꂽlł͂ȂA
	 * ǂݍލۂɎۂɗpꂽZbgێ܂B
	 */
	private java.nio.charset.Charset actualCharset_;
	
	/**
	 * FF[4]ST[0]ŏ܂B
	 */
	public RootGameTree() {
		super();
		actualCharset_ = null;
	}
	
	
    /**
	 * @param src
	 */
	public RootGameTree(RootGameTree src) {
		super(src);
		ArgumentChecker.throwIfNull(src);
		actualCharset_ = src.actualCharset_;
		SgfArgumentChecker.throwIfInvalid(this);
	}


	/**
	 * ݒ̏ꍇ݂͌̊ł̃ftHgCharsetw肵܂B
     * @return Returns the actualCharset.
     */
    public Charset getActualCharset() {
        return (actualCharset_ != null) ? actualCharset_ : Charset.defaultCharset();
    }
    /**
     * @param actualCharset The actualCharset to set.
     */
    public void setActualCharset(Charset actualCharset) {
        actualCharset_ = actualCharset;
    }
    
	/**
	 * AvP[VvpeBݒ肵܂B
	 * l̓m[hɒɔf܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void setApplication(Application application) {
	    ArgumentChecker.throwIfNull(application);
	    
	    clearRootProperty(SgfId.APPLICATION);
	    Sequence sequence = getSequence();
        Node node = sequence.isEmpty() ? new Node() : sequence.getFirst(); 
	    node.addProperty(SgfId.APPLICATION.makeProperty(application));
	}


	//TODO 
	//     \[XII
	//     [gm[h{@link findInRoot()}ŌOK
	//     setcn͈֐SgfTypeŌĂяoOK
	//     cƂsvȋCĂB
    /**
	 * FFvpeBݒ肵܂B
	 * l̓m[hɒɔf܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void setFileFormat(FileFormat fileFormat) {
	    ArgumentChecker.throwIfNull(fileFormat);

	    Node node = BasicFinder.findNode(getSequence(), SgfId.FILE_FORMAT);
		if (node == null) {
		    if (getSequence().size() != 0) {
			    node = getSequence().getFirst();
		    } else {
		        node = new Node();
		    }
		}
		node.addProperty(SgfId.FILE_FORMAT.makeProperty(fileFormat));
	}
	
	/**
	 * CAvpeBݒ肵܂B
	 * l̓m[hɒɔf܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void setCharset(SgfCharset charset) {
	    ArgumentChecker.throwIfNull(charset);

	    Node node = BasicFinder.findNode(getSequence(), SgfId.CHARSET);
		if (node == null) {
		    if (getSequence().size() != 0) {
			    node = getSequence().getFirst();
		    } else {
		        node = new Node();
		    }
		}
		node.addProperty(SgfId.CHARSET.makeProperty(charset));
	}

	/**
	 * GMvpeBݒ肵܂B
	 * l̓m[hɒɔf܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void setGameMode(GameMode gameMode) {
	    ArgumentChecker.throwIfNull(gameMode);

	    Node node = BasicFinder.findNode(getSequence(), SgfId.GAME_MODE);
		if (node == null) {
		    if (getSequence().size() != 0) {
			    node = getSequence().getFirst();
		    } else {
		        node = new Node();
		    }
		}
		node.addProperty(SgfId.GAME_MODE.makeProperty((SgfNumber)gameMode.typeName()));
	}


	/**
	 * SZvpeBݒ肵܂B
	 * l̓m[hɒɔf܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void setSize(SgfSize size) {
	    ArgumentChecker.throwIfNull(size);
		getRootNode().addProperty(SgfId.SIZE.makeProperty(size));
	}

	/**
	 * STvpeBݒ肵܂B
	 * l̓m[hɒɔf܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void setStyle(Style style) {
	    ArgumentChecker.throwIfNull(style);
		getRootNode().addProperty(SgfId.STYLE.makeProperty(style));
	}

	/**
	 * GTvpeBݒ肵܂B
	 * l̓m[hɒɔf܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void setGameType(GameType gameType) {
	    ArgumentChecker.throwIfNull(gameType);
	    
		// TODO SGFTYPELongName邩ƂĎw肷KvB
		getRootNode().addProperty(new Property(/*Sgfs.GAME_TYPE.id*/"GTT", gameType.getString()));
	}
	
	/** m[h݂Ȃꍇ́AĂԂ܂B*/
	private Node getRootNode() {
		Sequence sequence = getSequence();
		Node node;
		if (sequence.isEmpty()) {
			node = new Node();
			sequence.addFirst(node);
		} else {
			node = sequence.getFirst();
		}
		return node;
	}


	// Getter
	/** ȂꍇnullԂ܂ */
	public Application getApplication() {
		String datum = BasicFinder.findDatum(getSequence(), SgfId.APPLICATION);
		if (Strings.EMPTY.equals(datum)) {
		    return null;
		}
		try {
            return Application.parse(datum);

		} catch (TypeParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
		return null;
	}
	
	public FileFormat getFileFormat() {
		Property property = findInRoot(SgfId.FILE_FORMAT);
        if (property == null) {
        	return FileFormat.VERSION_4;
        }
        try {
            return FileFormat.parse(property.getString());
        } catch (TypeParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    	return FileFormat.VERSION_4;
	}

	/**
	 * t@CŎw肳ĂR[hԂ܂B
	 * ȂꍇNULLԂ܂B
	 * @return NULL
	 */
	public SgfCharset getSgfCharset() {
		Property property = findInRoot(SgfId.CHARSET);
        if (property == null) {
        	return null;
        }
        return SgfCharset.parse(property.getString());
	}

	public SgfNumber getGameMode() {
		Property property = findInRoot(SgfId.GAME_MODE);
        if (property == null) {
        	return (SgfNumber)GameMode.IGO.typeName();
        }
        return (SgfNumber)GameMode.parse(property.getString()).typeName();
	}

	/** ȂꍇSize.DEFAULTԂ܂B*/
	public SgfSize getSize() {
		try {
			Property property = findInRoot(SgfId.SIZE);
			if (property == null) {
				return SgfSize.DEFAULT;
			}
			return SgfSize.parse(property.getString());
			
		} catch (TypeParseException e) {
			throw new InvalidSgfStateException(e);
		}
	}

	/**
	 * nullԂȂƂۏ؂܂B
	 */
	public Style getStyle() {
		Property property = findInRoot(SgfId.STYLE);
        if (property == null) {
        	return Style.DEFAULT;
        }
        Style ret = Style.parse(property.getString());
        return ret == null ? Style.DEFAULT : ret;
	}

	/** ȂꍇGameType.GAMEԂ܂ */
	public GameType getGameType() {
		Property property = findInRoot(SgfId.GAME_TYPE);
		if (property == null) {
			return GameType.GAME;
		}
		try {
			return GameType.parse(property.getString());

		} catch (TypeParseException e) { //TODO O
			return GameType.GAME;
		}
	}
	
	/**
	 * ݂ȂꍇnodeȂꍇnullԂ܂B
	 */
	private Property findInRoot(SgfId sgfId) {
		if (getSequence().isEmpty()) {
			return null;
		}
		return getSequence().getFirst().getProperty(sgfId);
	}

	/**
	 * GameTree̐擪̃m[hāA
	 * YtypeProperty폜܂B 
     */
    private void clearRootProperty(SgfId type) {
        Sequence sequence = getSequence();
        if (sequence.isEmpty()) {
            return;
        }
        sequence.getFirst().removeProperty(type.id());
    }
}
