/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

import org.unitarou.util.ArgumentChecker;


/**
 * SGFtH[}bgɂSequence\NXłB
 * ɈȏNodẽXgێ܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
final public class Sequence implements Iterable<Node> {
	
	/**
	 * {@link Sequence#iterator()}ŕԂiteratorłB<br>
	 * ̃Ce[^{@link #remove()}T|[g܂B
	 * K{@link UnsupportedOperationException}𑗏o܂B
	 */
	static public class Iterator implements java.util.Iterator<Node> {
		private final ListIterator<Node> iterator_;
		
		/**
		 * @param list
		 */
		private Iterator(List<Node> list) {
			super();
			iterator_ = list.listIterator();
		}
		
		/* (non-Javadoc)
		 * @see java.util.Iterator#hasNext()
		 */
		public boolean hasNext() {
			return iterator_.hasNext();
		}
		
		/* (non-Javadoc)
		 * @see java.util.Iterator#next()
		 */
		public Node next() {
			return iterator_.next();
		}

		/**
		 * @throws UnsupportedOperationException Ko܂B
		 * @see java.util.Iterator#remove()
		 */
		public void remove() {
			throw new UnsupportedOperationException();
		}
	}
	
	/** ^[Node]łB*/
	private final List<Node> nodes_;

	/**
	 * 
	 */
	public Sequence() {
		super();
		nodes_ = new ArrayList<Node>();
	}

	/**
	 * Rs[RXgN^łB
	 * @param src
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public Sequence(Sequence src) {
		ArgumentChecker.throwIfNull(src);
		nodes_ = new ArrayList<Node>(src.nodes_);
	}

	/**
	 * Xg̐擪nodeǉ܂B<b>node͕ʂ܂B</b><br>
	 * āAnodeɏCƁA
	 * ̃CX^Xێnode͉e󂯂܂B
	 */
	public void addFirst(Node node) {
		nodes_.add(0, node);	
	}

	/**
	 * Xg̖[nodeǉ܂B<b>node͕ʂ܂B</b><br>
	 * āAnodeɏCƁA
	 * ̃CX^Xێnode͉e󂯂܂B
	 */
	public void addLast(Node node) {
		nodes_.add(node);		
	}
	
	/**
	 * nodeinsertPoint̒Oɒǉ܂B<b>node͕ʂ܂B</b><br>
	 * āAnodeɏCƁA
	 * ̃CX^Xێnode͉e󂯂܂B
	 * ̃\bhł̓V[PX̖ɒǉł܂B
	 * V[PX̖ɒǉꍇ{@link #addLast(Node)}\bhgĂB
	 * 
	 * @throws IllegalArgumentException insertPointł̃CX^Xɑ݂ȂꍇB
	 * @throws org.unitarou.lang.NullArgumentException insertPointnull̏ꍇ
	 */
	public void insert(Node node, Node insertPoint) {
	    ArgumentChecker.throwIfNull(insertPoint);

	    int index = nodes_.indexOf(insertPoint);
		if (index == -1) {
			throw new IllegalArgumentException();
		}
		nodes_.add(index, node);
	}
	
	/**
	 * ݂̃Xg̍Ōseq	uencȇSnodeǉ܂B
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ 
	 */
	public void addAll(Sequence sequence) {
	    ArgumentChecker.throwIfNull(sequence);

	    nodes_.addAll(sequence.nodes_);
	}
	
	/**
	 * Xg node폜܂B
	 * 폜ɐtrueԂ܂B
	 */
	public boolean remove(Node node) {
		return nodes_.remove(node);
	}
	
	/**
	 * Xg̖[Node폜A폜NodeԂ܂B
	 * Xg̏ꍇnullԂ܂B 
	 */
	public Node removeLast() {
		return (0 < nodes_.size()) ? (Node)nodes_.remove(nodes_.size() - 1) : null;
	}
	
	/** 
	 * ێĂnodeׂč폜܂B
	 */
	public void clear() {
	    nodes_.clear();
	}
	
	//getter\bh
	/** XgłtrueԂ܂B*/
	public boolean isEmpty() {
		return nodes_.isEmpty();
	}
	/**
	 * ̃CX^XێĂNode̐Ԃ܂B
	 */
	public int size() {
		return nodes_.size();
	}

	/**
	 * Xg̐擪ɂNodeCX^XԂ܂B 
	 */
	public Node getFirst() {
		return nodes_.get(0); 
	}

	/**
	 * Xg̖ɂNodeCX^XԂ܂B
	 * Xg̏ꍇAnullԂ܂B 
	 */
	public Node getLast() {
		return (0 < nodes_.size()) ? (Node)nodes_.get(nodes_.size() -1) : null; 
	}

	/**
	 * destination̖ɌݕێĂSnode܂B
	 * destinationnodeɏCƁA
	 * ̃CX^Xێnode͉e󂯂܂B
	 */
	public Node[] getNodes() {
		return nodes_.toArray(new Node[nodes_.size()]);
	}
	
	
	/**
	 * CX^XێĂNodeiteratorԂ܂B 
	 */
	public Iterator iterator() {
		return new Iterator(nodes_);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		
		if (obj == null || !obj.getClass().equals(getClass())) {
			return false;
		}
		
		Sequence des = (Sequence)obj;
		return nodes_.equals(des.nodes_);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		int ret = nodes_.size() * 133;
		if (nodes_.size() != 0) {
			ret += nodes_.get(0).hashCode();
		}
		return ret;
	}
}
