/*
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.lang.NamedEnum;
import org.unitarou.lang.Strings;
import org.unitarou.lang.UEnum;
import org.unitarou.ml.MessageResource;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

/**
 * vpeB̂̂̌^`NXłB<br>
 * eCX^XImmutableł邱Ƃۏ؂܂B
 */
final public class SgfId extends NamedEnum {
    static private final Messages type_s_ = Messages.createByPackage(SgfId.class, "type"); //$NON-NLS-1$
    static private final Messages typeName_s_ = Messages.createByPackage(SgfId.class, "typename"); //$NON-NLS-1$
	
    /** ̃NXp郍K[łB */
    static private final Log logger_s_ = LogFactory.getLog(SgfId.class);
	
    /** type.properties̃p[XɎs܂B^{0}ŎsJ{1}łB */
	static private final MessageResource MSG_TYPE_CANT_PARSED 
			= new MessageResource(SgfId.class, "SgfId.msgTypeCantParsed"); //$NON-NLS-1$
	
	/** sȃvpeB */
	static private final MessageResource LB_UNKNOWN  
			= new MessageResource(SgfId.class, "lbUnknown"); //$NON-NLS-1$
	
	/**
	 * 
	 */
    static private final EnumSet<GameType> defaultTarget_s_ = EnumSet.of(GameType.GAME);
    
    /** */
    static public final SgfId ADD_BLACK = new SgfId("AB"); //$NON-NLS-1$

    static public final SgfId ADD_EMPTY = new SgfId("AE"); //$NON-NLS-1$

    static public final SgfId ANNOTATION = new SgfId("AN"); //$NON-NLS-1$

    static public final SgfId APPLICATION = new SgfId("AP"); //$NON-NLS-1$

    static public final SgfId ARROW = new SgfId("AR"); //$NON-NLS-1$

    static public final SgfId ADD_WHITE = new SgfId("AW"); //$NON-NLS-1$

    static public final SgfId BLACK = new SgfId("B"); //$NON-NLS-1$

    static public final SgfId BLACK_TIME_LEFT = new SgfId("BL");//$NON-NLS-1$

    static public final SgfId BAD_MOVE = new SgfId("BM"); //$NON-NLS-1$

    static public final SgfId BLACK_RANK = new SgfId("BR"); //$NON-NLS-1$

    static public final SgfId BLACK_TEAM = new SgfId("BT"); //$NON-NLS-1$

    static public final SgfId COMMENT = new SgfId("C"); //$NON-NLS-1$

    static public final SgfId CHARSET = new SgfId("CA"); //$NON-NLS-1$

    static public final SgfId COPYRIGHT = new SgfId("CP"); //$NON-NLS-1$

    static public final SgfId CIRCLE = new SgfId("CR"); //$NON-NLS-1$

    static public final SgfId DIM_POINTS = new SgfId("DD"); //$NON-NLS-1$

    static public final SgfId EVEN_POSITION = new SgfId("DM"); //$NON-NLS-1$

    static public final SgfId DOUBTFUL = new SgfId("DO"); //$NON-NLS-1$

    static public final SgfId DATE = new SgfId("DT"); //$NON-NLS-1$

    static public final SgfId EVENT = new SgfId("EV"); //$NON-NLS-1$

    static public final SgfId FILE_FORMAT = new SgfId("FF"); //$NON-NLS-1$

    static public final SgfId FIGURE = new SgfId("FG"); //$NON-NLS-1$

    static public final SgfId GOOD_FOR_BLACK = new SgfId("GB"); //$NON-NLS-1$

    static public final SgfId GAME_COMMENT = new SgfId("GC"); //$NON-NLS-1$

    static public final SgfId GAME_MODE = new SgfId("GM"); //$NON-NLS-1$

    static public final SgfId GAME_NAME = new SgfId("GN"); //$NON-NLS-1$

    /** LmV^IWi^OłB3:lA4:lW */ 
    static public final SgfId GAME_TYPE = new SgfId("GT"); //$NON-NLS-1$

    static public final SgfId GOOD_FOR_WHITE = new SgfId("GW"); //$NON-NLS-1$

    static public final SgfId HANDICAP = new SgfId("HA"); //$NON-NLS-1$

    static public final SgfId HOTSPOT = new SgfId("HO"); //$NON-NLS-1$

    /** LmV^IWi^OłB΃pX`œǂݍރt@Cw肵܂B'\''/'ɃGXP[v܂ */
    static public final SgfId INPUT_FILES = new SgfId("IF"); //$NON-NLS-1$

    static public final SgfId INTERESTING = new SgfId("IT"); //$NON-NLS-1$

    static public final SgfId KOMI = new SgfId("KM"); //$NON-NLS-1$

    static public final SgfId KO = new SgfId("KO"); //$NON-NLS-1$

    static public final SgfId LABEL = new SgfId("LB"); //$NON-NLS-1$

    static public final SgfId LINE = new SgfId("LN"); //$NON-NLS-1$

    static public final SgfId MARK_WITH_X = new SgfId("MA"); //$NON-NLS-1$

    static public final SgfId SET_MOVE_NUMBER = new SgfId("MN"); //$NON-NLS-1$

    static public final SgfId NODENAME = new SgfId("N"); //$NON-NLS-1$//$NON-NLS-2$

    static public final SgfId OVER_TIME_STONES_BLACK = new SgfId("OB"); //$NON-NLS-1$

    static public final SgfId OPENING = new SgfId("ON"); //$NON-NLS-1$

    static public final SgfId OVERTIME = new SgfId("OT"); //$NON-NLS-1$

    static public final SgfId OVER_TIME_STONES_WHITE = new SgfId("OW"); //$NON-NLS-1$

    static public final SgfId PLAYER_BLACK = new SgfId("PB"); //$NON-NLS-1$

    static public final SgfId PLACE = new SgfId("PC"); //$NON-NLS-1$

    static public final SgfId PLAYER_TO_PLAY = new SgfId("PL"); //$NON-NLS-1$

    static public final SgfId PRINT_MOVE_MODE = new SgfId("PM"); //$NON-NLS-1$

    /** LmV^IWi^OłBHi ] Ԑ 蒼 Vbt qg\ Lo */
    static public final SgfId PROBLEM_PROPERTIES = new SgfId("PP"); //$NON-NLS-1$

    static public final SgfId PLAYER_WHITE = new SgfId("PW"); //$NON-NLS-1$

    static public final SgfId RESULT = new SgfId("RE"); //$NON-NLS-1$

    static public final SgfId ROUND = new SgfId("RO"); //$NON-NLS-1$

    static public final SgfId RULES = new SgfId("RU"); //$NON-NLS-1$

    static public final SgfId SELECTED = new SgfId("SL"); //$NON-NLS-1$

    static public final SgfId SOURCE = new SgfId("SO"); //$NON-NLS-1$

    static public final SgfId SQUARE = new SgfId("SQ"); //$NON-NLS-1$

    static public final SgfId STYLE = new SgfId("ST"); //$NON-NLS-1$

    static public final SgfId SIZE = new SgfId("SZ"); //$NON-NLS-1$

    static public final SgfId TERRITORY_BLACK = new SgfId("TB"); //$NON-NLS-1$

    static public final SgfId TESUJI = new SgfId("TE"); //$NON-NLS-1$

    static public final SgfId TIME_LAPSED = new SgfId("TL"); //$NON-NLS-1$
    
    static public final SgfId TIMELIMIT = new SgfId("TM"); //$NON-NLS-1$

    static public final SgfId TRIANGLE = new SgfId("TR"); //$NON-NLS-1$
    
    static public final SgfId TERRITORY_WHITE = new SgfId("TW"); //$NON-NLS-1$
    
    static public final SgfId UNCLEAR_POS = new SgfId("UC"); //$NON-NLS-1$

    static public final SgfId USER = new SgfId("US"); //$NON-NLS-1$

    static public final SgfId VALUE = new SgfId("V"); //$NON-NLS-1$

    static public final SgfId VIEW = new SgfId("VW"); //$NON-NLS-1$

    static public final SgfId WHITE_TIME_LEFT = new SgfId("WL"); //$NON-NLS-1$

    static public final SgfId WHITE_RANK = new SgfId("WR"); //$NON-NLS-1$

    static public final SgfId WHITE_TEAM = new SgfId("WT"); //$NON-NLS-1$

    /** ̒܂B*/
    static public final SgfId WHITE = new SgfId("W"); //$NON-NLS-1$
    


    
    /**
     * idɕRtTypeԂ܂B<br>
     * `̏ꍇ́A{@link #id_}==idA{@link #version_}=={false, false, false, false, false}A
     * {@link #name_}==Unknown elementA{@link #propertyType_}=={@link PropertyType#ANY}
     * {@link #valueType_}=={@link CardinalityType#ELIST}ƂȂCX^X𐶐ĕԂ܂B 
     * @param id
     * @return
     */
    static public SgfId find(String id) {
        SgfId ret = (SgfId)UEnum.find(SgfId.class, Sgfs.convertRegularId(id));
        if (ret == null) {
            ret = new SgfId(id, 
                    			VersionType.get(Strings.EMPTY), 
                    			defaultTarget_s_,
                    			LB_UNKNOWN.get(),
                    			PropertyType.ANY,
                    			CardinalityType.ELIST,
                    			ValueType.OTHER); 
        }
        return ret;
    }

	
	/** At@xbg啶݂̂ō\鐳ID nullɂ͌ĂȂ܂B*/
	private final String id_;
	private final VersionType version_;
	private final EnumSet<GameType> gameTypes_;
    private final String name_;
    private final PropertyType propertyType_;
    private final CardinalityType cardinalityType_;
    private final ValueType valueType_;

    /** 
     * {@link #find(String)}̂݌ĂяoRXgN^łB
     */
    private SgfId(
            String i, 
            VersionType v, 
            EnumSet<GameType> t,
            String d, 
            PropertyType pt,
            CardinalityType ct,
            ValueType vt) 
    {
        super(Sgfs.convertRegularId(i));
        id_ = Sgfs.convertRegularId(i);
        version_ = v;
        gameTypes_ = EnumSet.copyOf(t);
        name_ = d;
        propertyType_ = pt;
        cardinalityType_ = ct;
        valueType_ = vt;
    }

    /**
     * {̃RXgN^łB
     */
    private SgfId(String id) {
        super(id);
        try {
            id_ = id;
            name_ = typeName_s_.get(id_);

            StringTokenizer tokenizer = new StringTokenizer(type_s_.get(id_), ","); //$NON-NLS-1$
            if (tokenizer.hasMoreTokens()) {
                version_ = VersionType.get(tokenizer.nextToken().trim());

            } else {
                logger_s_.warn(MSG_TYPE_CANT_PARSED.get(id, "version")); //$NON-NLS-1$
                version_ = VersionType.get(Strings.EMPTY);
                gameTypes_ = null;
                propertyType_ = null;
                cardinalityType_ = null;
                valueType_ = null;
                return;
            }
            
            if (tokenizer.hasMoreTokens()) {
                gameTypes_ = GameType.parseSetQuietly(tokenizer.nextToken().trim(), defaultTarget_s_);

            } else {
                logger_s_.warn(MSG_TYPE_CANT_PARSED.get(id, "target")); //$NON-NLS-1$
                gameTypes_ = defaultTarget_s_;
                propertyType_ = null;
                cardinalityType_ = null;
                valueType_ = null;
                return;
            }

            
            if (tokenizer.hasMoreTokens()) {
                propertyType_ = PropertyType.valueOf(tokenizer.nextToken().trim());
               
            } else {
                logger_s_.warn(MSG_TYPE_CANT_PARSED.get(id, "type")); //$NON-NLS-1$
                propertyType_ = null;
                cardinalityType_ = null;
                valueType_ = null;
                return;
            }
            

            if (tokenizer.hasMoreTokens()) {
                cardinalityType_ = CardinalityType.get(tokenizer.nextToken().trim());
               
            } else {
                logger_s_.warn(MSG_TYPE_CANT_PARSED.get(id, "cardinality")); //$NON-NLS-1$
                cardinalityType_ = null;
                valueType_ = null;
                return;
            }

            if (tokenizer.hasMoreTokens()) {
            	ValueType valueType = null;
            	String key = tokenizer.nextToken().trim();
            	try {
            		valueType = ValueType.valueOf(key);
            	} catch (IllegalArgumentException exception) {
            		logger_s_.warn("Unknown type: ID:" + id_ + " valueType:" + key); //$NON-NLS-1$ //$NON-NLS-2$
            		valueType = ValueType.OTHER;
            	}
            	valueType_ = valueType;
               
            } else {
                logger_s_.warn(MSG_TYPE_CANT_PARSED.get(id, "valueType")); //$NON-NLS-1$
                valueType_ = null;
            }
        } catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }



    /**
     * @return
     */
    public String id() {
        return id_;
    }
    
    /**
     * @return
     */
    public VersionType version() {
        return version_;
    }
    
    /**
     * {@link SgfId}Kp{@link GameType}̏WԂ܂B<br>
     * ʂlԂ̂ŁACsĂCX^Xɉe͂܂B
     * @return
     */
    public EnumSet<GameType> gameTypes() {
    	return EnumSet.copyOf(gameTypes_);
    }

    /* (non-Javadoc)
     * @see org.unitarou.lang.NameDisplayable#displayName()
     */
    @Override
	public String displayName() {
        return name_;
    }
    
    /**
     * Property̌^([gpAQ[pApAetc...)
     * \{@link PropertyType}Ԃ܂Bnull͕Ԃ܂B
     */
    public PropertyType propertyType() {
        return propertyType_;
    }

    public CardinalityType cardinalityType() {
        return cardinalityType_;
    }

    /**
     * l("[...]"̕)̑`񋓌^CX^XԂ܂B
     * null͕Ԃ܂B
     */
    public ValueType valueType() {
        return valueType_;
    }
    
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
	public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append(", ").append(propertyType_); //$NON-NLS-1$
        buffer.append(", ").append(cardinalityType_); //$NON-NLS-1$
        buffer.append(", ").append(valueType_); //$NON-NLS-1$
        return buffer.toString();
    }

    /**
     * ̌^type{@link Property}܂B 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     * @throws IllegalArgumentException ̃CX^X̌^typeȂꍇɑo܂B
     */
    public Property makeProperty(TypedString<?> typedString) {
        ArgumentChecker.throwIfNull(typedString);
        
        // ^`FbN
        if (!typedString.acceptable(this)) {
            throw new IllegalArgumentException("Bad type this: " + this //$NON-NLS-1$
					+ ", type: " + typedString); //$NON-NLS-1$
        }
        return new Property(this, typedString.getString());
    }
    
    /**
     * ̌^types{@link Property}܂B 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     * @throws IllegalArgumentException ̃CX^X̌^typesȂꍇɑo܂B
     */
    public Property makeProperty(TypedString<?>[] types) {
        ArgumentChecker.throwIfNull((Object[])types);
        
        List<Value> values = new ArrayList<Value>(types.length);
        for (TypedString<?> typedString : types) {
            if (!typedString.acceptable(this)) {
                throw new IllegalArgumentException("Bad type this: " + this //$NON-NLS-1$
    					+ ", type: " + typedString); //$NON-NLS-1$
            }
            values.add(new Value(typedString.getString()));
        }
        Property ret = new Property();
        ret.setId(this.id_);
        ret.addValue(values.toArray(new Value[values.size()]));
        return ret;
    }
}