/*
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;

import java.io.File;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.util.ArgumentChecker;


/**
 * SGFŋK肳Ă鏔X̌^W߂萔NXłB
 * tH[}bg̏ڍׂɂĂhttp://www.red-bean.com/sgf/QƁB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
final public class Sgfs {
	/** (Game tree)̊JnL('(')ł */
	static public final char GAME_TREE_START_MARK ='(';

	/** (Game tree)̏IL(')')ł */
	static public final char GAME_TREE_END_MARK =')';

	/** m[h̊JnLi';'jłB*/
	static public final char NODE_START_MARK = ';';

	/** l̊JnLi'['jłB */
	static public final char VALUE_START_MARK = '[';

	/** l̏ILi']'jłB */
	static public final char VALUE_END_MARK = ']';

	/** escape(̂̕܂܈)soft line break(̉s𖳎)̃^O('\')LłB */
	static public final char ESCAPE_SOFT_LINE_BREAK = '\\';
	
	/** compose^̑Oƌ㔼؂Zp[^(':')łB*/
	static public final char COMPOSE_SEPARATOR = ':';
	
	/** ST̒l */
	static public final int ST_CHILDLEN = 0;

	/** ST̒l */
	static public final int ST_SIBLINGS = 1;
	
	/**
	 * {@link SgfId#INPUT_FILES}fBXNɕێۂ
	 * OS̃t@CZp[^͂̕('/')ɒuA
	 * fBXNǂݏoOS̃t@CZp[^ɒu܂B
	 */
	static public final char IF_FILE_SEPARATOR_ESCAPE_MARK = '/';
	
	/**
	 * SGFt@C̊gq"sgf"(sIh܂܂)ێ܂B
	 */
	static public final String EXTENSION = "sgf"; //$NON-NLS-1$
	
	/**
	 * string̃GXP[v{@link #ESCAPE_SOFT_LINE_BREAK}܂B
	 * {@link #unescapeTextForRead(String)}{@link #unescapeSimpleTextForRead(String)}Ƃ
	 * قȂAzCgXy[Xs' 'ɕϊ܂B
	 * 
	 * @param string
	 * @return
	 */
	static public CharSequence unespaceForRead(CharSequence string) {
	    ArgumentChecker.throwIfNull(string);

	    StringBuilder sb = new StringBuilder(string.length());
	    for (int i = 0; i < string.length(); ++i) {
	    	char c = string.charAt(i);
	        if (c != ESCAPE_SOFT_LINE_BREAK) {
                sb.append(c);
	            continue;
	        }
	      
	        c = next(string, i);
	        if (c == CharacterIterator.DONE) {
	        	break;
	        }
	        ++i;
	        if ('\r' == c) {
	            c = next(string, i);
		        if (c == CharacterIterator.DONE) {
		            break;
		        }
		        ++i;
		        if ('\n' != c) {
		            sb.append(c);
		        }
		        
	        } else if ('\n' == c) {
	            c = next(string, i);
		        if (c == CharacterIterator.DONE) {
		            break;
		        }
		        ++i;
		        if ('\r' != c) {
		            sb.append(c);
		        }
	        } else {
	            sb.append(c);
	        }
	    }
	    return sb;
	}
	
	/**
	 * charSequenceindex̎̒lԂ܂B<br>
	 * index͈͂𒴂Ăꍇ{@link CharacterIterator#DONE}Ԃ܂B
	 * @param charSequence
	 * @param index
	 * @return
	 */
	static private char next(CharSequence charSequence, int index) {
		return (0 <= index && index + 1 < charSequence.length()) 
				? charSequence.charAt(index + 1) 
				: CharacterIterator.DONE; 
	}
	/**
	 * datumSGFText^Ƃ݂ȂāA
	 * ̃GXP[v{@link #ESCAPE_SOFT_LINE_BREAK}`pɏ܂B
	 * 
	 * ȂSWT͓VM̉sR[hOƂĂ̂ŁA
	 * SWTւ̕\pɂ͕ʓrϊKvłB
	 * 
	 * @return GXP[v폜ꂽB
	 * @throws NullArgumentException null̏ꍇB
	 */
	static public String unescapeTextForRead(String datum) {
	    ArgumentChecker.throwIfNull(datum);

	    StringBuilder sb = new StringBuilder(datum.length());
	    CharacterIterator iter = new StringCharacterIterator(datum);
	    for (char c = iter.first(); c != CharacterIterator.DONE; c = iter.next()) {
	        if (c != ESCAPE_SOFT_LINE_BREAK) {
	            if (c == '\r' || c == '\n' || !Character.isWhitespace(c)) {
	                sb.append(c);
	            } else {
	                sb.append(' ');
	            }
	            continue;
	        }
	        c = iter.next();
	        if ('\r' == c) {
	            c = iter.next();
		        if (c == CharacterIterator.DONE) {
		            break;
		        } else if ('\n' != c) {
		            sb.append(c);
		        }
	        } else if ('\n' == c) {
	            c = iter.next();
		        if (c == CharacterIterator.DONE) {
		            break;
		        } else if ('\r' != c) {
		            sb.append(c);
		        }
	        } else {
	            sb.append(c);
	        }
	    }
	    return sb.toString();
	}

	/**
	 * datumSGFSimpleText^Ƃ݂ȂāA
	 * ̃GXP[v{@link #ESCAPE_SOFT_LINE_BREAK}`pɏ܂B
	 * 
	 * ȂSWT͓VM̉sR[hOƂĂ̂ŁA
	 * SWTւ̕\pɂ͕ʓrϊKvłB
	 * 
	 * @return GXP[v폜ꂽB
	 * @throws NullArgumentException null̏ꍇB
	 */
	static public String unescapeSimpleTextForRead(String datum) {
	    ArgumentChecker.throwIfNull(datum);

	    StringBuilder sb = new StringBuilder(datum.length());
	    CharacterIterator iter = new StringCharacterIterator(datum);
	    for (char c = iter.first(); c != CharacterIterator.DONE; c = iter.next()) {
	        if (c != ESCAPE_SOFT_LINE_BREAK) {
	            if (!Character.isWhitespace(c)) {
	                sb.append(c);
	            } else {
	                sb.append(' ');
	            }
	            continue;
	        }
	        c = iter.next();
	        if ('\r' == c) {
	            c = iter.next();
		        if (c == CharacterIterator.DONE) {
		            break;
		        } else if ('\n' != c) {
		            sb.append(c);
		        }
	        } else if ('\n' == c) {
	            c = iter.next();
		        if (c == CharacterIterator.DONE) {
		            break;
		        } else if ('\r' != c) {
		            sb.append(c);
		        }
	        } else {
	            sb.append(c);
	        }
	    }
	    return sb.toString();
	}

	/**
	 * GXP[v{ĂȂtextSGFŕۑł`ɕϊ܂B
	 * ̓Iɂ́e]fƁe\fGXP[v܂B
	 * Soft line break('\\n', '\\r', '\\r\n')̏ꍇ͂̂܂܂ɂ܂B
	 * 
	 * TODO Ƃ肠e:f̓GXP[vΏۊOɂĂ
	 * @return GXP[vꂽ
	 *
	 * @throws NullArgumentException null̏ꍇB
	 */
	static public String escapeForStore(String text) {
	    ArgumentChecker.throwIfNull(text);
	    
	    StringBuilder sb = new StringBuilder(text.length());
	    CharacterIterator iter = new StringCharacterIterator(text);
	    for (char c = iter.first(); c != CharacterIterator.DONE; c = iter.next()) {
	        switch (c) {
	        case ']':
	        	sb.append('\\');
	            sb.append(c);
	        	break;
	        	
	        case '\\':
	        	char nc = iter.next();
	        	if (nc != '\n' && nc != '\r') {
		        	sb.append('\\');
	        	}
	        	iter.previous();
	            sb.append(c);
	        	break;

	        default :
	            sb.append(c);
	        	break;
	        }
	    }
	    return sb.toString();
	}
	
	
	/**
	 * {@link SgfId#INPUT_FILES}̒lǂݏoۂɁA
	 * {@link #IF_FILE_SEPARATOR_ESCAPE_MARK}OS̃t@CZp[^ɒu郍WbNłB
	 * @param ifValue
	 * @return
	 * @throws NullArgumentException <code>null</code>̏ꍇ
	 */
	static public String unescapeIfForRead(String ifValue) {
		ArgumentChecker.throwIfNull(ifValue);
		return ifValue.replace(IF_FILE_SEPARATOR_ESCAPE_MARK, File.separatorChar);
	}
	
	/**
	 * {@link SgfId#INPUT_FILES}̒lۑۂɁA
	 * OS̃t@CZp[^{@link #IF_FILE_SEPARATOR_ESCAPE_MARK}ɒu郍WbNłB
	 * @param ifValue
	 * @return
	 * @throws NullArgumentException <code>null</code>̏ꍇ
	 */
	static public String escapeIfForStore(String ifValue) {
		ArgumentChecker.throwIfNull(ifValue);
		return escapeForStore(ifValue.replace(File.separatorChar, IF_FILE_SEPARATOR_ESCAPE_MARK));
	}

	
    /**
     * idSGFIndentƂĐłtrueԂ܂B
     * ̓Iɂ͂PȏQȉ̃At@xbg啶݂̂
     * \ĂꍇtrueԂ܂B
     * 
     * @param id
     */
    static public boolean isValidId(String id) {
    	if ((id == null) || (id.length() == 0) || (2 < id.length())) {
    		return false;
    	}
    	for (int i = 0; i < id.length(); ++i) {
    		final char c = id.charAt(i);
    		if ((c < 'A') || ('Z' < c)) {
    			return false;
    		}
    	}
    	return true;
    }

    /**
     * entireIdSGFIndentƂċełtrueԂ܂B
     * ̓Iɂ́Aꕶȏ̃At@xbg啶܂܂A
     * SĂAt@xbgłꍇłB
     * @param entireId
     * @return
     */
    static public boolean isValidEntireId(String entireId) {
    	if ((entireId == null) || (entireId.length() == 0)) {
    		return false;
    	}
    	
    	boolean containsUpperLetter = false;
    	for (int i = 0; i < entireId.length(); ++i) {
    		final char c = entireId.charAt(i);
    		if (('A' <= c) && (c <= 'Z') ) {
    			containsUpperLetter = true;
    
    		} else if ((c < 'a') || ('z' < c)) {
    			return false;
    		}
    	}
    	return containsUpperLetter;
    }

    /**
     * entireIdSGFIndentƂĐȌ`ɕϊ܂B<br>
     * ̓Iɂ͑啶̃At@xbĝ
     * 擪񕶎𔲂oԂ܂B
     * 
     * @param entireId
     * @return
     */
    static public String convertRegularId(String entireId) {
    	ArgumentChecker.throwIfNull(entireId);
    	if (entireId.length() == 0) {
        	return entireId;
        }
    	
    	StringBuilder ret = new StringBuilder();
    	for (int i = 0; i < entireId.length(); ++i) {
    		final char c = entireId.charAt(i);
    		if (('A' <= c) && (c <= 'Z') ) {
    			ret.append(c);
    			if (ret.length()==2) {
    				break; 
    			}
    		}
    	}
    	assert(0 < ret.length() && ret.length() <= 2);
    	return ret.toString();
    }

	/**
	 * SGFōWƂėpa-zA-Z1-52̐ɕϊ܂B
	 * <pre>
	 * a -> 1
	 * z -> 26
	 * A -> 27 
	 * Z -> 52
	 * </pre>
	 * łB
	 * @param c
	 * @return 1-52̐l
	 * 
	 * @throws IllegalArgumentException c[a-zA-Z]͈̔͊ȌꍇB
	 */
	static public int fromSgf(char c) {
		if (('a' <= c && c <= 'z') || ('A' <= c && c <= 'Z')) {
			return (c <= 'Z') ? (c - 'A' + 27) : (c - 'a' + 1); 
	    }
	    throw new IllegalArgumentException("c is out of range: " + c); //$NON-NLS-1$
	}

	/**
	 * positionՂX,Yǂ炩̍WƂ݂ȂāA
	 * SGF̃tH[}bgɕϊĕԂ܂B
	 * Ⴆ1a, 2błB
	 * @throws IllegalArgumentException position0ȉ{@link SgfSize#MAX_LENGTH}傫ꍇB
	 * 
	 */
	static public char toSgf(int position) {
	    if ((position <= 0) || (SgfSize.MAX_LENGTH < position)) {
	        throw new IllegalArgumentException(
	                "position is out of range:" + position); //$NON-NLS-1$
	    }
		return (position <= 26) 
				? (char)('a' + position - 1) 
		        : (char)('A' + position - 27);  
	}
    
	
	/**
	 * gameTree̍ŏʂGameTreeԂ܂B<br>
	 * ʂɂ͖߂l̃NX{@link RootGameTree}łA
	 * 肩Ȃǂ̏ꍇɂGameTreeԂ܂B
	 * 
	 * @param gameTree
	 * @return
	 */
	static public GameTree getRoot(GameTree gameTree) {
		ArgumentChecker.throwIfNull(gameTree);
        GameTree p = gameTree;
		while(p.getParent() != null) {
		    p = p.getParent();
		}
		return p;
	}

    // ܂ŃNXϐƃNX\bh
}
