/*  
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;

import org.unitarou.lang.NullArgumentException;
import org.unitarou.lang.Strings;
import org.unitarou.util.ArgumentChecker;

/**
 * ۂ̒l[...]̎O{@link org.unitarou.sgf.Utr}܂ł
 * ܂߂lNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class Value {
    /** ̃CX^Xi[Ăf[^̂̂łB*/
    private final String string_;
    

	/**
	 * Value|n_̎Ouc[vɂ|̈łB
	 * {IWhite spacê݂܂B
	 * Qm~NXUTR(Untranslated Region)O̗RłB
	 */
	private final String openUtr_;
	
	/**
	 * {@link #hashCode()}̒lێ܂B
	 * {@link #string_}{@link #openUtr_}XV0Zbg܂B
	 */
	private int hashCode_;
  
    /**
     * value,UTRɋ̃CX^X쐬܂B
     */
    public Value() {
    	this(Strings.EMPTY, Strings.EMPTY);
    }

    /**
     * valuelUTR̃CX^X쐬܂B
     * @throws NullArgumentException null̏ꍇ
     */
    public Value(CharSequence value) {
    	this(value, Strings.EMPTY);
    }
    
    /**
     * valueUTRw肵ăCX^X쐬܂B
     * @throws NullArgumentException null̏ꍇ
     */
    public Value(CharSequence value, CharSequence openUtr) {
        ArgumentChecker.throwIfNull(value);
        
        string_ = value.toString();
        openUtr_ = openUtr.toString();
        hashCode_ = 0;
    }

    /**
     * ̃NX̃Rs[RXgN^łB
     * @throws NullArgumentException null̏ꍇ
     */
    public Value(Value src) {
        super();
        ArgumentChecker.throwIfNull(src);
        string_ = src.string_;
        openUtr_ = src.openUtr_;
        hashCode_ = src.hashCode_;
    }

    /**
     * nullԂȂƂۏ؂܂B
     */
    public String getString() {
        return string_;
    }
    
	/**
	 * Value|n_̎Ouc[vɂ|̈Ԃ܂B<br>
	 * <code>null</code>͕Ԃ܂B
	 */
	public String getOpenUtr() {
		return openUtr_;
	}

    /**
     * getOpeningUTR() + "[" + getValue() +"]"̕Ԃ܂B 
     */
    @Override
	public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(openUtr_);
		sb.append(Sgfs.VALUE_START_MARK);
		sb.append(string_);
		sb.append(Sgfs.VALUE_END_MARK);
        return sb.toString();
    }
    
    /**
     * {@link #string_}{@link #utr_}ɓꍇtrueԂ܂B
     */
    @Override
	public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if ((obj == null) || !obj.getClass().equals(Value.class)) {
            return false;
        }
        Value o1 = (Value)obj;
        return string_.equals(o1.string_) 
        		&& openUtr_.equals(o1.openUtr_);
    }

    /**
     * {@link #string_}œǂ]A{@link #utr_}͖܂B
     */
    public boolean equalsIgnoreUTR(Value target) {
        if (this == target) {
            return true;
        }
        if (target == null) {
            return false;
        }
        return string_.equals(target.string_); 
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
	public int hashCode() {
    	if (hashCode_ == 0) {
    		hashCode_ = 7 * string_.hashCode() + 11 * openUtr_.hashCode(); 
    	}
        return hashCode_;
    }
}
