/* ValueType.java
 *
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;

import org.unitarou.lang.Strings;

/**
 * l("[...]"̕)̑`񋓌^NXłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public enum ValueType {
	/** Ӗ܂B*/
	NONE,

	/** tӖ܂B [("+"|"-")] Digit { Digit }*/ 
	NUMBER,

	/** tӖ܂BSgfNumber ["." Digit { Digit }] */
	REAL,
	
	/** lӖ܂B ("1" | "2") */
	DOUBLE,
	
	/** vC[Ӗ܂B("B" | "W")*/
	COLOR,
	
	/** s̐䕶܂܂ȂeLXgӖ܂B*/ 
	SIMPLE_TEXT,
	
	/** sʓIȃeLXgӖ܂B*/ 
	TEXT,
	
	/** "MOVE : MOVE"MOVEǂ炩Ӗ܂B*/ 
	POINT,
	
	/** "MOVE : MOVE"Ӗ܂B */ 
	CPOINT,

	/** Տ̈ʒuӖ܂Baa`ZZ */ 
	MOVE,

	/** LŕނłȂ^Ӗ܂B*/ 
	OTHER;
	
	/**
	 * typelǂԂ܂B<br>
	 * ̓IɂLISTELIST̏ꍇ݂̂trueԂ܂B
	 */
	static public boolean permitsMultiValues(CardinalityType type) {
		return (type == CardinalityType.LIST) || (type == CardinalityType.ELIST);
	}
	
	/**
	 * typelǂԂ܂B<br>
	 * ̓IɂELISTNONȄꍇ݂̂trueԂ܂B
	 */
	static public boolean permitsEmpty(CardinalityType ctype, ValueType vtype) {
		return (ctype == CardinalityType.ELIST) || (vtype == ValueType.NONE);
	}
	
	/**
	 * numberOfValuestypeɓKĂ邩mF܂B
	 */
	static public boolean isVaild(CardinalityType type, Value[] values) {
		boolean ret;
		switch (values.length) {
			case 0:
			ret = false;
			break;
				
			case 1:
			ret = !(type.equals(NONE) && !values[0].getString().equals(Strings.EMPTY));
			break;
			
			default:
			ret = permitsMultiValues(type);	
		}
		return ret;
	}
}

