/*
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf;

import java.util.Arrays;

import org.unitarou.lang.UEnum;
import org.unitarou.util.ArgumentChecker;


/**
 * vpeBK肳Ăt@CtH[}bgio[Wj\NXłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
final public class VersionType extends UEnum {
    
    /**
     * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    static public VersionType get(String versions) {
        ArgumentChecker.throwIfNull(versions);

        char[] verChars = versions.toCharArray();
        Arrays.sort(verChars);
        String typeName = new String(verChars);
        UEnum e = find(VersionType.class, typeName);
        return (e == null) ? new VersionType(typeName) : (VersionType)e;
    }
    
    
    /**
     * @param typeName
     */
    private VersionType(String typeName) {
        super(typeName);
    }
}