/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Sequence;
import org.unitarou.util.ArgumentChecker;


/**
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class AddGameTree extends AbstractCommand {
	private final GameTree target_;
	private final GameTree child_;
	private Node additionPoint_;
	private boolean appendAsSequence_;

	/**
	 * 
	 */
	public AddGameTree(GameTree target, GameTree child) {
		super();
		ArgumentChecker.throwIfNull(target, child);
		target_  = target;
		child_ = child;
		additionPoint_ = null;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		if (0 < target_.getChildren().length) {
			target_.addGameTree(child_);
			appendAsSequence_ = false;
			
		} else {
			Sequence sequence = target_.getSequence();
			appendAsSequence_ = true;
			additionPoint_ = sequence.getLast();
			for (Node node : child_.getSequence()) {
				target_.getSequence().addLast(node);
			}
			
			for (GameTree children : child_.getChildren()) {
				target_.addGameTree(children);
			}
		}	
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		if (!appendAsSequence_) {
			target_.removeGameTree(child_);
			
		} else {
			Node last = target_.getSequence().removeLast();
			while (last != additionPoint_) {
				last = target_.getSequence().removeLast();
			}
			if (additionPoint_ != null) {
				target_.getSequence().addLast(last);
			}
				 
			for (GameTree children : target_.getChildren()) {
				child_.addGameTree(children);
			}
			
			additionPoint_ = null;
		}
	}
}
