/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;

/**
 * {@link org.unitarou.sgf.Node}{@link org.unitarou.sgf.Sequence}̖ɒǉR}hłB
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class AddNode extends AbstractCommand {
	private final GameTree tree_;
	private final Node newNode_;

	/**
	 * newNodetree.getSequence()̖ɒǉR}h𐶐܂B
	 */
	public AddNode(GameTree tree, Node newNode) {
		super();
		if ((tree == null) || (newNode == null)) {
			throw new NullPointerException("Arguments must not be null. "  //$NON-NLS-1$
										+	"tree = " + tree + " newNode = " + newNode);  //$NON-NLS-1$ //$NON-NLS-2$
		}
		tree_ = tree;
		newNode_ = newNode;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		tree_.getSequence().addLast(newNode_);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		Node lastNode = tree_.getSequence().removeLast();
		if (!newNode_.equals(lastNode)) {
			throw new IllegalStateException("Cannot remove addition node. " //$NON-NLS-1$
											+ "lastNode = " + lastNode + "additionNode = " +  newNode_);  //$NON-NLS-1$//$NON-NLS-2$
		}
	}

}
