/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link org.unitarou.sgf.Node#addProperty(Property)}sR}hłB<br>
 * ɓIDProperty݂ꍇ͏㏑܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class AddProperty extends AbstractCommand {
	private final Node node_;
	private final Property property_;
	private Property lastProperty_;

	/**
	 * 
	 */
	public AddProperty(Node node, Property property) {
		super();
		ArgumentChecker.throwIfNull(node, property);

		node_ = node;
		property_ = property;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		lastProperty_ = node_.getProperty(property_.sgfId());
		node_.addProperty(property_);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		Property removed = node_.removeProperty(property_.getId());
		if (lastProperty_ != null) {
			node_.addProperty(lastProperty_);
			lastProperty_ = null;
		}
		
		// 폜Ɏs遨sԂ
		if (!property_.equals(removed)) {
			throw new IllegalStateException("Cannot remove addition node. " //$NON-NLS-1$
											+ "removed = " + removed + " additionNode = " +  node_);  //$NON-NLS-1$//$NON-NLS-2$
		}
	}
}
