/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.cmd;



import org.unitarou.cmd.AbstractCommand;
import org.unitarou.cmd.Command;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;

/**
 * {@link org.unitarou.sgf.GameTree}w肵m[h̎qƂĒǉR}hłB<br>
 * 
 * g_{@link org.unitarou.sgf.Sequence}̖łꍇ
 * {@link org.unitarou.sgf.cmd.AddGameTree}s܂B<br>
 * 
 * g_{@link org.unitarou.sgf.Sequence}̖ȊȌꍇ́A
 * {@link org.unitarou.sgf.cmd.CreateGameTreeImpl}s܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class CreateGameTree extends AbstractCommand {
	private final Command command_;
	
	/**
	 * 
	 */
	public CreateGameTree(GameTree parent, Node extensionPoint, GameTree child) {
		super();
		
		if (parent.getSequence().getLast() == extensionPoint) { 
			command_ = new AddGameTree(parent, child);
		} else {
			command_ = new CreateGameTreeImpl(parent, extensionPoint, child);
		}
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		command_.execute();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		command_.undo();
	}
}
