/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;

/**
 * {@link org.unitarou.sgf.Sequence}̓r
 * VKɎq{@link org.unitarou.sgf.GameTree}쐬܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
class CreateGameTreeImpl extends AbstractCommand {
	
	private final GameTree parent_;
	private final Node extensionPoint_;
	private final GameTree child_;
	/**
	 * 
	 */
	CreateGameTreeImpl(GameTree parent, Node extensionPoint, GameTree child) {
		super();
		if ((parent == null) || (extensionPoint == null) || (child == null)) {
			throw new NullPointerException("Arguments must not be null. "  //$NON-NLS-1$
										+ " parent = " + parent  //$NON-NLS-1$
										+ " extensionPoint = " + extensionPoint //$NON-NLS-1$
										+ " child = " + child);  //$NON-NLS-1$ 
		}
		parent_ = parent;
		extensionPoint_ = extensionPoint;
		child_ = child;
	}

	/**
	 * ASŶ͎ƂB
	 * <ol>
	 * <li>g_܂{@link Node}폜܂B</li>
	 * <li>폜Nodeq{@link GameTree}Ƃēo^܂B</li>
	 * <li>ǉq{@link GameTree}o^܂B</li>
	 * </ol>
	 * @see org.unitarou.sgf.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		GameTree mainstream = new GameTree();
		Node last = parent_.getSequence().removeLast();
		while (last != extensionPoint_) {
			mainstream.getSequence().addFirst(last);
			last = parent_.getSequence().removeLast();
		}
		parent_.getSequence().addLast(last);//extensionPoint_͎cB
		
		GameTree[] children = parent_.getChildren();
		for (int i = 0; i < children.length; ++i) {
			mainstream.addGameTree(children[i]);
		}
		
		parent_.clearGameTree();
		parent_.addGameTree(mainstream);
		parent_.addGameTree(child_);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		GameTree[] children = parent_.getChildren();
		for (Node node : children[0].getSequence()) {
			parent_.getSequence().addLast(node);
		}
		parent_.clearGameTree();
		
		GameTree[] pastChildren = children[0].getChildren();
		for (int i = 0 ; i < pastChildren.length; ++i) {
			parent_.addGameTree(pastChildren[i]);
		}
	}
}
