/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.lang.Strings;
import org.unitarou.lang.UEnum;
import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.SgfPointSet;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link org.unitarou.sgf.Property}IuWFNg̕ҏWsR}hłB<br>
 * ̓Iɂ(ǉu)A(폜)s܂B
 * ꂼRXgN^̈Ŏw肵܂B
 * 
 * {@link org.unitarou.sgf.Property}̒ľ^ZxɉāA
 * ǉűς܂B
 * Point̍č\Ȃ܂B
 * 
 * ΉłȂ{@link org.unitarou.sgf.SgfId}w肳ꂽꍇ́A
 * ł{@link java.lang.IllegalArgumentException}𑗏o܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class EditProperty extends AbstractCommand {
    /**
     * ҏW̎(ǉXVA폜)^NXłB 
     */
    static public class EditType extends UEnum {
        protected EditType(String typeName) {
            super(typeName);
        }
    }
    static public EditType ADD_OR_REPLACE = new EditType("Add or replace"); //$NON-NLS-1$
    static public EditType DELETE = new EditType("Delete"); //$NON-NLS-1$
    
    private final Node node_;
    private final Property target_;
    
    /** 
     * sO{@link #node_}ɓĂ
     * {@link #target_}ƓID̃vpeBłB
     */
    private final Property backup_;
    private final EditType editType_;
    
    /**
     * nodeɑ΂target̒ǉE폜s܂B
     * ǉƍ폜editTypeŎw肵܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public EditProperty(Node node, Property target, EditType editType) {
        super();
        ArgumentChecker.throwIfNull(node, target, editType);
        node_ = node;
        target_ = target;
        backup_ = node_.getProperty(target_.sgfId());
        editType_ = editType;
    }
    
    /**
     * ̃R}h{@link EditType}Ԃ܂B
     * @return
     */
    public EditType getEditType() {
        return editType_;
    }
    
    /**
     * ̃R}h{@link SgfId}Ԃ܂B
     */
    public SgfId getSgfId() {
        return target_.sgfId();
    }
    

    /* (non-Javadoc)
     * @see org.unitarou.cmd.Command#execute()
     */
    @Override
	public void execute() {
        super.execute();

        // nodetargetID݂Ȃ
        if (backup_ == null) {
            // ǉύX̏ꍇ́AǉďIB
            if (ADD_OR_REPLACE.equals(editType_)) {
                node_.addProperty(target_);
            }
            // 폜̏ꍇ͖ďI
            return;
        }
        
        // ݂ꍇtarget̔ZxPȂ
        CardinalityType ct = target_.sgfId().cardinalityType();
        if (CardinalityType.SINGLE.equals(ct)){
            // ǉύX̏ꍇ͒uďI
            if (ADD_OR_REPLACE.equals(editType_)) {
                node_.addProperty(target_);
                
            // 폜̏ꍇ͍폜ďIB
            } else if (DELETE.equals(editType_)) {
                node_.removeProperty(target_.getId());
            }
            return;
        }

        // Zxlist, elist̏ꍇ́Aľ^ɍ킹đ݃`FbN
        if (CardinalityType.LIST.equals(ct)) {
            editList();
            return;
        } else if (CardinalityType.ELIST.equals(ct)) {
            editEList();
            return;
        }

        // ZxYȂꍇ̓G[
        assert false : "Unknown cardinality : " + ct; //$NON-NLS-1$
    }
    
    /**
     * ZxPȊO({@link CardinalityType#LIST}܂{@link CardinalityType#ELIST})
     * ꍇɎsҏWWbNłB
     */
    private void editList() {
        ValueType vt = target_.sgfId().valueType();
        if (ValueType.POINT.equals(vt)) {
            editListByPoint();
            
        } else if (SgfId.LABEL.equals(target_.sgfId())) {
            editListByLabel();
            
        } else {
        	editListByOther();
        }
    }
    
    /**
     * Zx{@link CardinalityType#ELIST}
     * ꍇɎsҏWWbNłB
     */
    private void editEList() {
    	// vf"[]"target_̏ꍇ́A
    	// ݂̒lƒuɂȂB
    	for (String datum : target_.getStrings()) {
    		if (Strings.EMPTY.equals(datum)) {
    			node_.removeProperty(target_.getEntireId());
    			node_.addProperty(target_);
    			return;
    		}
    	}
        ValueType vt = target_.sgfId().valueType();
        if (ValueType.POINT.equals(vt)) {
            editListByPoint();
            
        } else {
        	editListByOther();
        }
    }

    /**
     * {@link ValueType}{@link ValueType#POINT}̎
     * sҏWWbNłB
     * {@link ValueType}ł͕^[aa:cc]Ȃǂ݂邽߁A
     * USĂValuePointɕϊA}[WA폜sA
     * Ōɍő`œKv܂B
     */
    private void editListByPoint() {
        // ܂݂POINTACPOINT΂΂SgfPointɕB
        SgfPointSet sgfPointSet = new SgfPointSet();
        sgfPointSet.add(SgfPoint.parse(SgfSize.MAX, backup_.getStrings()));
        
        
        // ǉύX̏ꍇ̓}[W
        if (ADD_OR_REPLACE.equals(editType_)) {
            sgfPointSet.add(SgfPoint.parse(SgfSize.MAX, target_.getStrings()));
            
        // 폜̏ꍇ͍폜B
        } else if (DELETE.equals(editType_)) {
            sgfPointSet.remove(SgfPoint.parse(SgfSize.MAX, target_.getStrings()));
            
            if (sgfPointSet.isEmpty()) {
                node_.removeProperty(target_.getId());
                return;
            }
        }
        // `ɐ؂oAedited쐬B
        Property edited = new Property();
        edited.setId(backup_.getId());
        SgfRectangle[] rectangles = sgfPointSet.getRegularRectangles();
        for (int i = 0; i < rectangles.length; ++i) {
            edited.addValue(new Value(rectangles[i].getValue()));
        }
        node_.addProperty(edited);
    }
    

    /**
     * {@link #target_}{@link SgfId#LABEL}̏ꍇɎsҏWWbNłB
     * x̏ꍇ͓ŁAO̍Wꍇ̂ݓƂ݂ȂAҏWs܂B
     */
    private void editListByLabel() {
        // ȑÕvpeB̑݃`FbNsA
        // Kvɉď㏑ĂB
        // TODO \[XI
        // uWvƂ\bhLabelɗpӂĂĂԂׂB
        Property edited = new Property(backup_);
        String[] data = target_.getStrings();
        for (int i = 0; i < data.length; ++i) {
            boolean found = false;
            try {
                String dataPos = Label.parseString(data[i])[0];
                Value[] oldValues = edited.getValues();
                for (Value oldValue : oldValues) {
                    String oldPos = Label.parseString(oldValue.getString())[0];
                    if (dataPos.equals(oldPos)) {
                        edited.removeValue(oldValue);
                        if (ADD_OR_REPLACE.equals(editType_)) {
                            edited.addValue(new Value(data[i], oldValue.getOpenUtr()));
                        }
                        found = true;
                        break;
                    }
                }
                if (!found && ADD_OR_REPLACE.equals(editType_)) {
                    edited.addValue(new Value(data[i]));
                }
            } catch (TypeParseException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        
        // targetƂŒlȂA
        // Propertŷ̂폜B
        if (edited.size() == 0) {
            node_.removeProperty(edited.getId());
        } else {
            node_.addProperty(edited);
        }
    }
    
    /**
	 * {@link #target_}{@link ValueType#POINT},{@link SgfId#LABEL}
	 * ȊÔƂɎsҏWWbNłB<br>
	 * ǉ͏d͖܂B
	 * 폜͈v̂̂ݍ폜܂B
	 */
	private void editListByOther() {
        Property edited = new Property(backup_);
        // USč폜B
        Value[] values = target_.getValues();
        for (int i = 0; i < values.length; ++i) {
        	edited.removeValue(values[i]);
        }

        // ǉύX̏ꍇ͂̌ǉ}[W
        if (ADD_OR_REPLACE.equals(editType_)) {
            edited.addValue(target_.getValues());
        }
        
        // USč폜
        node_.removeProperty(edited.getId());
        if (edited.size() != 0) {
            node_.addProperty(edited);
        }
	}
    
    
    /* (non-Javadoc)
     * @see org.unitarou.cmd.Command#undo()
     */
    @Override
	public void undo() {
        super.undo();
        
        // ǉύX폜AǂobNAbvƒuB
        // obNAbv݂Ȃꍇ́Ã^[Qbg폜B
        if (backup_ == null) {
            node_.removeProperty(target_.getId());
        } else {
            node_.addProperty(backup_);
        }
    }
}
