/*
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Sequence;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link GameTree}̎w肵ꏊ{@link org.unitarou.sgf.Node}ǉR}hłB
 *
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class InsertNode extends AbstractCommand {
	private final GameTree tree_;
	private final Node insertPoint_;
	private final Node newNode_;

	/**
	 * newNodetree.getSequence()insertPoint̒Oɑ}R}h𐶐܂B<br>
	 * tree.getSequence()̖ɑ}ꍇ{@link AddNode}g܂B
	 * @param tree }ΏۂłB
	 * @param insertPoint ̃m[ḧOnewNode}܂B
	 * @param newNode ̃m[hVɑ}܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
	 * @throws IllegalArgumentException insertPointtreeɊ܂܂ĂȂꍇB
	 */
	public InsertNode(GameTree tree, Node insertPoint, Node newNode) {
		super();
		ArgumentChecker.throwIfNull(tree, insertPoint, newNode);
		if (!contain(tree.getSequence(), insertPoint)) {
		    throw new IllegalArgumentException("insertPoint doesn't contain tree!"); //$NON-NLS-1$
		}
		
		tree_ = tree;
		insertPoint_ = insertPoint;
		newNode_ = newNode;
	}
	
    /**
     * sequencenodeCX^XƂĊ܂܂ĂꍇtrueԂ܂B
     * 
     * @throws NullArgumentException null̏ꍇ
     */
	private boolean contain(Sequence sequence, Node targetNode) {
        ArgumentChecker.throwIfNull(sequence, targetNode);
        for (Node node : sequence) {
            if (node == targetNode) {
                return true;
            }
        }
        return false;
    }


	/* (non-Javadoc)
	 * @see org.unitarou.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		tree_.getSequence().insert(newNode_, insertPoint_);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		tree_.getSequence().remove(newNode_);
	}
}
