/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.util.ArgumentChecker;

/**
 * parent_target_폜܂B<br>
 * ō폜̌ʂɂĎqGameTreePȂꍇ́A
 * ẽV[PXɓ܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class RemoveGameTree extends AbstractCommand {
	private final GameTree parent_;
	private final GameTree target_;
	private GameTree[] children_;
	private Node extensionPoint_;

	/**
	 * targetparent폜R}h𐶐܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public RemoveGameTree(GameTree parent, GameTree target) {
		super();
		ArgumentChecker.throwIfNull(parent, target);
		if (!parent.containsDirectly(target)) {
			throw new IllegalArgumentException(target + " is not a child of " + parent); //$NON-NLS-1$
		}

		parent_  = parent;
		target_ = target;
		children_ = null;
		extensionPoint_ = null;
	}

	/**
	 * parent_target_폜܂B<br>
	 * ō폜̌ʂɂĎqGameTreePȂꍇ́A
	 * ẽV[PXɓ܂B
	 * 
	 * @see org.unitarou.sgf.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		children_ = parent_.getChildren();
		parent_.removeGameTree(target_);
		
		GameTree[] newChildren = parent_.getChildren();
		if (newChildren.length != 1) {
			extensionPoint_ = null;

		} else {
			GameTree child = newChildren[0];
			extensionPoint_ = parent_.getSequence().getLast();
	 		for (Node node : child.getSequence()) {
				parent_.getSequence().addLast(node);
	 		}
			parent_.clearGameTree();
			for (GameTree gameTree : child.getChildren()) {
				parent_.addGameTree(gameTree);
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		if (extensionPoint_ != null) {
			Node last = parent_.getSequence().getLast();
			while (last != extensionPoint_) {
				last = parent_.getSequence().removeLast();
			}
			parent_.getSequence().addLast(last);
			
			GameTree merged = (children_[0] == target_) ? children_[1] : children_[0];
			for (GameTree child : parent_.getChildren()) {
				merged.addGameTree(child);
			}
			extensionPoint_ = null; 
		}

		parent_.clearGameTree();
		for (int i = 0 ; i < children_.length; ++i) {
			parent_.addGameTree(children_[i]);
		}
		
		children_ = null;
	}
}
